;******************************************************************************
;* some useful cdf utilites, like to find out variables, attributes,
;* etc. in CDF files. Needs CDF V 2.6 linked into IDL.
;******************************************************************************


;******************************************************************************
;*  NAME:        papco_cdf_cracker
;*
;*  DESCRIPTION: Return information about variables and attributes in
;*               cdf file
;*
;*  INPUT:       id  - CDF file id returned by cdf_open
;*
;*  KEYWORDS:    GLOBAL_ATTRIB  - returns all global attributes of cdf file
;*               VAR_ATTRIB     - returns all variable attribturs of cdf file
;*               ZVARIABLES     - returns list of zVariables 
;*               RVARIABLES     - returns list of rVariables 
;*               GET_VAR_ATTRIB - returns all variable attributes of
;                                 this variable
;*               VERBOSE        - print results of enquiery to screen
;*
;*
;*  OUTPUT:      none (places data into variables passed by keywords)
;*
;*  DATE:        October 2000
;*
;*  AUTOR:       R. Friedel
;******************************************************************************
pro papco_cdf_cracker, id, GLOBAL_ATTRIB=GLOBAL_ATTRIB, VAR_ATTRIB=VAR_ATTRIB,$
                       ZVARIABLES=ZVARIABLES, RVARIABLES=RVARIABLES, $
                       GET_VAR_ATTRIB=GET_VAR_ATTRIB, VARNAME=VARNAME, $
                       VERBOSE=VERBOSE
  
  !quiet=1
  
  if keyword_set(VERBOSE) then verbose=verbose else verbose=0
  
  ;get top level info on cdf
  cdf_info=cdf_inquire(id)  
  
  if keyword_set(GLOBAL_ATTRIB) then begin
    ;find out about all global attributes
    cdf_control, id, get_numattrs=numattrs  
    print,varprt(numattrs(0)),' Global attributes.'
    global_attr=strarr(numattrs(0),2)
    count=0
    for i=0, cdf_info.NATTS -1 do begin
      cdf_attinq, id, i, atr_name, scope, MaxEntry, MaxZEntry
      cdf_control,id, attribute=atr_name, get_attr_info=attr_info
      if scope eq 'GLOBAL_SCOPE' then begin
        global_attr(count,0)=atr_name        
        cdf_attget, id, atr_name, attr_info.MAXGENTRY ,attr_value
        global_attr(count,1)=attr_value
        if verbose then print, strformat(atr_name,18,/right), ': ',attr_value
        count=count+1
      endif
    endfor    
    GLOBAL_ATTRIB=global_attr
  endif
  
  if keyword_set(VAR_ATTRIB) then begin
    ;find out about all variable attributes
    cdf_control, id, get_numattrs=numattrs  
    if verbose then print,varprt(numattrs(1)),' Variable attributes.'
    var_attr=strarr(numattrs(1))
    count=0
    for i=0, cdf_info.NATTS -1 do begin
      cdf_attinq, id, i, atr_name, scope, MaxEntry, MaxZEntry
      ;cdf_control,id, attribute=atr_name, get_attr_info=attr_info
      if scope eq 'VARIABLE_SCOPE' then begin
        var_attr(count,0)=atr_name        
        if verbose then print, strformat(atr_name,18,/right)
        count=count+1
      endif
    endfor    
    VAR_ATTRIB=var_attr
  endif
  
  if keyword_set(ZVARIABLES) then begin
    ;find out what z variables are in this cdf
    if cdf_info.NZVARS eq 0 then print,'No zVariables' else begin
      zvars=strarr(cdf_info.NZVARS,2)
      for i=0, cdf_info.NZVARS -1 do begin
        cdf_control, id, variable=i, /zvariable, get_var_info=var_info
        var_inq=cdf_varinq( id, i, /zvariable)
        zvars(i,0)=var_inq.name
        zvars(i,1)=var_inq.datatype
        if verbose then print, strformat(varprt(i),2,/right), ' ', $
          strformat(var_inq.name,30,/right),$
          strformat(var_inq.datatype,12,/right),'   ', $
          strformat(varprt(var_inq.numelem), 4, /right), '   ', $
          strformat(var_inq.recvar,8,/right), $
          '    ',var_inq.dimvar
      endfor    
      ZVARIABLES=zvars
    endelse
  endif
  
  if keyword_set(RVARIABLES) then begin
    ;find out what r variables are in this cdf
    if cdf_info.NVARS eq 0 then print,'No rVariables' else begin
      rvars=strarr(cdf_info.NVARS,2)
      for i=0, cdf_info.NVARS -1 do begin
        cdf_control, id, variable=i, get_var_info=var_info
        var_inq=cdf_varinq( id, i, /zvariable)
        rvars(i,0)=var_inq.name
        rvars(i,1)=var_inq.datatype
        if verbose then print, strformat(varprt(i),2,/right), $
          strformat(var_inq.name,25,/right),$
          strformat(var_inq.datatype,12,/right),'   ', $
          varprt(var_inq.numelem),'   ',strformat(var_inq.recvar,8,/right),$
          '    ',var_inq.dimvar
      endfor    
      RVARIABLES=rvars
    endelse
  endif  
  
  if keyword_set(GET_VAR_ATTRIB) then begin
    ;find out what attributes variable in VAR_ATTRIB has  - return structure
    ;first see if it's a valid variable name
    if keyword_set(VARNAME) then var_name=VARNAME else begin
      message,'You need to specify variable name in keyword VARNAME',/cont
      return
    endelse
    zvars=1  &  papco_cdf_cracker, id, ZVARIABLES=zvars
    pos=strpos(zvars(*,0), var_name)  &  index=where(pos ne -1, c)
    if c eq 0 then begin
      print,var_name+' is not a z variable name in this CDF file'
      print,'valid z variable names are:'
      print,zvars(*,0)
    endif else begin
      print, var_name+' is a valid z Variable name'
      ;now get all possible variable atribute names
      ;first get all variable attributes
      var_attrib=1  &  papco_cdf_cracker, id, VAR_ATTRIB=var_attrib
      this_var_attrib=strarr(n_elements(var_attrib),2)  &  count=0
      for i=0, n_elements(var_attrib)-1 do begin
        att_exist=cdf_attexists(id, var_attrib(i), var_name)
        if att_exist then begin
          cdf_attget, id, var_attrib(i), var_name ,attr_value
          if verbose then print, var_name,' >  ', $
            strformat(var_attrib(i),15,/right),'  : ',attr_value
          this_var_attrib(count,0)=var_attrib(i)
          this_var_attrib(count,1)=attr_value
          count=count+1
        endif
      endfor
      this_var_attrib=this_var_attrib(0:count-1)
      GET_VAR_ATTRIB=this_var_attrib
    endelse
  endif
  
  !quiet=0
 
end
