pro papco_data_cache_tool_event, event
  widget_control, widget_info(event.top,/child), get_uvalue=widgetData
  widget_control, event.id, get_uvalue=uval

  if n_elements( uval ) eq 0 then uval=''

  if uval eq 'transfer' then begin
      x= widget_info( widgetData.id_list, /table_select )
      files= (*widgetData.remoteList)(x[1]:x[3])
      cache= widgetData.cache

      widgetData.monitor->setTaskSize, n_elements(files)
      for i=0,n_elements(files)-1 do begin
          widgetData.monitor->setProgress, i
          cache->transfer, files[i]
          if ( widgetData.monitor->isCancelled() ) then break
      endfor
      papco_data_cache_tool_refresh, event.top
  endif else if uval eq 'dismiss' then begin
      widget_control, event.top, /destroy
  endif else if uval eq 'cancel' then begin
      isCancelled= 1
  endif else if uval eq 'reset' then begin
      cache= widgetData.cache
      cache->reset
      papco_data_cache_tool_refresh, event.top, cache
  endif else begin
      ;; resize
      new_table_size= [ event.x, event.y-40 ]
      widget_control, widgetData.id_list, $
        scr_xsize= new_table_size[0], $
        scr_ysize= new_table_size[1]
      cwidth= ( new_table_size[0]-100 ) / 2
      widget_control, widgetData.id_list, $
        column_widths= [cwidth,cwidth]
  endelse
end


function papco_data_cache_tool_monitor::Init, base
  self.idProgress= widget_label( base, map=0 )
  return, 1
end


function papco_data_cache_tool_build_widget, cache, $
                                             modal=modal, group_leader=group
  tool_base= widget_base( title='data cache tool', /column, /tlb_size_events,$
                          modal=modal, group=group )
  child= widget_base( tool_base )

  list_base= widget_base( tool_base, /row )

  list= widget_table( list_base, $
                      column_labels=['local','remote'],$
                      column_widths=[100,100], $
                      row_labels=strarr(24), $
                      value= strarr( 2, 24 ), $
                      ysize=24, /scroll )
  progress_base= widget_base( tool_base, /row )
  id_message= widget_text( progress_base, xsize=40, value='' )
  id_progress= 0

  id_draw= widget_draw( progress_base, ysize=20, xsize=30 )


  control_base= widget_base( tool_base, /row, /align_right )

  id_reset= widget_button( control_base, value='reset', uvalue='reset' )
  id_cancel= widget_button( control_base, value='Cancel', uvalue='cancel' )

  x= widget_button( control_base, value='Get Selected', uvalue='transfer' )
  x= widget_button( control_base, value='Dismiss', uvalue='dismiss' )

  widget_control, tool_base, /realize

  widget_control, list, tlb_get_size= list_size
  widget_control, tool_base, tlb_get_size= top_size

  monitor= obj_new( 'papco_graph_monitor', $
                    idMessage=id_message, idProgress=id_progress, $
                    idDraw=id_draw, idCancel=id_cancel )

  widgetData= { id_list:list, $
                id_list_size:list_size, $
                top_size:top_size, $
                id_cancel:id_cancel, $
                localList:ptr_new(), $
                remoteList:ptr_new(), $
                monitor:monitor, $
                cache: cache $
              }
  widget_control, child, set_uvalue= widgetData
  return, tool_base
end

function nelements, array
  if ( (size(array))[0] eq 0 ) then return, 0 else return, n_elements(array)
end

pro list_align, a1, a2
  s1= a1[sort(a1)]
  s2= a2[sort(a2)]
  if ( a1[0] eq '' ) then s1=''
  if ( a2[0] eq '' ) then s2=''

  n= nelements(s1) + nelements(s2)

  if n eq 0 then begin
      message, 'both lists are empty', /cont
      return
  endif

  r1= strarr( n )
  r2= strarr( n )
  i1= 0
  i2= 0
  ir= 0
  while ( i1 lt nelements(s1) and i2 lt nelements( s2 ) ) do begin
      if ( s1[i1] eq s2[i2] ) then begin
          r1[ir]= s1[i1]
          r2[ir]= s2[i2]
          i1= i1+1
          i2= i2+1
      endif else if ( s1[i1] lt s2[i2] ) then begin
          r1[ir]= s1[i1]
          r2[ir]= ''
          i1= i1+1
      endif else if ( s1[i1] gt s2[i2] ) then begin
          r1[i2]= ''
          r2[ir]= s2[i2]
          i2= i2+1
      endif

      ir= ir + 1
  endwhile

  while ( i2 lt nelements(s2) ) do begin
      r1[ir]=''
      r2[ir]=s2[i2]
      i2= i2+1
      ir= ir+1
  endwhile

  while ( i1 lt nelements(s1) ) do begin
      r2[ir]=''
      r1[ir]=s1[i1]
      i1= i1+1
      ir= ir+1
  endwhile

  a1= r1[0:(ir-1)]
  a2= r2[0:(ir-1)]
end

pro papco_data_cache_tool_refresh, id, cache
  widget_control, widget_info(id,/child), get_uvalue=widgetData

  cache= widgetData.cache

  widgetData.monitor->setTaskSize, 5
  widgetData.monitor->setMessage, 'examining local cache'
  local= cache->get_files_local( papco_new_timerange( '1/1/1958', $
                                                      '1/1/2060' ), $
                                 monitor= widgetData.monitor->newSubtaskMonitor(0,1) )
  widgetData.monitor->setMessage, 'examining remote cache'
  remote= cache->get_files_remote( papco_new_timerange( '1/1/1958', $
                                                        '1/1/2060' ), $
                                   monitor= widgetData.monitor->newSubtaskMonitor(1,5) )
  if ( local[0] eq '' and remote[0] eq '' ) then begin
      r= widget_message( 'no data in local or remote data stores' )
      widgetData.monitor->setMessage, 'no data found'
      return
  endif else begin
      widgetData.monitor->setmessage, ''+strtrim(nelements(local),2)+' local, '+strtrim(nelements(remote),2)+' remote files found'
  endelse


  list_align, local, remote

  widget_control, widgetData.id_list, table_ysize=n_elements(local)
  widget_control, widgetData.id_list, $
    set_value= [ transpose(local), transpose(remote) ]

  ptr_free, widgetData.localList
  widgetData.localList= ptr_new( local )
  ptr_free, widgetData.remoteList
  widgetData.remoteList= ptr_new( remote )

  widgetData.cache= cache

  dates= strarr( n_elements( remote ) )
  for i=0,n_elements(remote)-1 do begin
      f= local[i]
      if strtrim(f,2) eq '' then f= remote[i]
      tr= cache->range( f )
      dates[i]= strmid( ( tr->getStart() )->toString(), 0, 10 )

      if ( local[i] eq '' ) then begin
          if ( cache->has_Secondary_Cache() ) then begin
              x= (cache->get_seconary_Cache())->get_local( tr->getStart() )
              if ( x ne '' ) then local[i]='secondary'
          endif
      endif

  endfor
  widget_control, widgetData.id_list, row_labels= dates

  widget_control, widgetData.id_list, $
    set_value= [ transpose(local), transpose(remote) ]

  widgetData.monitor->finished

  widget_control, widget_info(id,/child), set_uvalue=widgetData
end

pro test
  cache= papco_data_cache( '/papco_data/omni/', 'omni2_%Y.dat', $
                            urlRoot='ftp://papco:pap_dat@nis-ftp.lanl.gov/omni/' )
;  cache= papco_data_cache( '/papco_data/noaa/', $
;                           'NOAA_N12/sem/2000/data/N12%Y%j.dat.gz', $
;                           urlRoot='ftp://papco:pap_dat@nis-ftp.lanl.gov/noaa/' )
  papco_data_cache_tool, cache

end

pro papco_data_cache_tool, cache, modal=modal, group_leader=group

  id= papco_data_cache_tool_build_widget(cache, modal=modal, group=group )
  
  papco_data_cache_tool_refresh, id

  xmanager, 'papco_data_cache_tool', id, /no_block
end


