; procedure to set up a polar plot of the equatorial plane, with central axis
; and polar grid.
;
; inputs:  max - how many erath radii out

pro papco_draw_eq_plane, max, NOERASE=NOERASE, CHARCOL=CHARCOL

   COMMON papco_color_names
   zz=0.8*!P.charsize
   
   if keyword_set(CHARCOL) then charcol=CHARCOL else charcol=1
   
;setup noerase for overplots
   if keyword_set(NOERASE) then myerase=NOERASE else myerase=0
   
;Setup axis system
   r=fltarr(100)
   r(*)=1.
   theta=findgen(100)
   theta=theta*0.06346651
   plot,r,theta,xsty=5,ysty=5,/polar,xr=[-1*max,max],yr=[-1*max,max], $
      thick=1,color=1, NOERASE=myerase

;overplot own axis 
    r(*)=1.
    case 1 of
      (max le 6)                 : begin & tn=max*2    & mi=4 & end
      (max gt 6)  and (max le 12): begin & tn=max    & mi=2 & end
      (max gt 12) and (max le 18): begin & tn=max/2  & mi=2 & end
      (max gt 18) and (max le 24): begin & tn=max/3  & mi=1 & end
      (max gt 24) and (max le 30): begin & tn=max/4  & mi=0 & end
      (max gt 30)                : begin & tn=max/5  & mi=0 & end
    endcase
      
    PLOT,r,theta,xsty=5,ysty=5,/polar,xr=[-1*max,max],yr=[-1*max,max], $
          thick=1, /noerase, color=1
    AXIS,xax=0,0,0,xr=[-1*max,max],yr=[-1*max,max],xtickf='nozero4', $
         ytickf='nozero4',xticks=tn,xmi=mi,ticklen=0.01,xsty=1,ysty=1, $
         charsize=zz,xthick=1, color=charcol, NOERASE=myerase
    AXIS,yax=0,0,0,xr=[-1*max,max],yr=[-1*max,max],xtickf='nozero4', $
         ytickf='nozero4',yticks=tn,ymi=mi,ticklen=0.01,xsty=1,ysty=1, $
         charsize=zz,ythick=1, color=charcol, NOERASE=myerase
    
;draw earth
    thearth=FINDGEN(50)
    thearth=(thearth*0.06411)-1.5708
    xray=COS(2*thearth)
    yray=SIN(2*thearth)
    POLYFILL,0.95*xray,0.95*yray, color=0
    xray=COS(thearth)
    yray=SIN(thearth)
    POLYFILL,xray,yray,color=royal_blue
;draw circles and lt line
    FOR i=2,max DO BEGIN
      r(*)=FLOAT(i)
      OPLOT,r,theta,/polar,lin=1,thick=1, color=1
    ENDFOR
   
;annotate around with LT labels.
   hour=findgen(24)
   theta=hour*0.261799
   r=findgen(24)
   r(*)=max
   for i=0,23 do oplot,[1.,r(i)],[theta(i),theta(i)],lin=1,/polar, color=1
      xray=(max+1)*cos(theta)
      yray=(max+1)*sin(theta)
      mltpos=sin(theta/2.)
   for i=0,23 do xyouts,xray(i),yray(i),string(hour(i), $
            format="(i2.2,' !CMLT')"),alignment=mltpos(i),charsize=zz, color=1
 
end

function nozero4,axis,index,t
if t lt 0. then t=-t
if (t eq 0.) or (t eq 1.) then return,' ' else return,string(t,format="(i4)")
end 
