pro papco_drawaxis,OVERPLOT=OVERPLOT,_extra=extra_par
  
  common mjdt, mjdt_start, mjdt_end
  common shift_label, down             ;common for x-axis label shifting
  
  ;check for overplot set
  if keyword_set(OVERPLOT) then return
  
  ;set axis color to black
  extra_par.color=1
  
  starttime= double(mjdt_start.t)
  endtime  = (mjdt_end.mjd - mjdt_start.mjd)*86400.0d + double(mjdt_end.t) 
  
  papco_timeticks, xtickvals, xtickformatstring, nticks=6
  nticks=n_elements(xtickvals) 
  
  if extra_par.xtickformat ne 'noticks' then $
    extra_par.xtickformat=xtickformatstring
  ;keep old time range for setting plot for old time coords
  old_range=extra_par.xrange
  extra_par.xrange=[starttime, endtime]
  
  print, extra_par.xtickformat
  
  mjdt_now=mjdt_start 
  for i=0,nticks-1 do begin
    t=xtickvals(i)
    add_days = t / 86400l
    add_sec  = t mod 86400l
    mjdt_now.mjd = mjdt_start.mjd + add_days
    mjdt_now.t   = add_sec
    if mjdt_now.t ge 86400 then begin
      mjdt_now.t  = mjdt_now.t  - 86400
      mjdt_now.mjd= mjdt_now.mjd + 1
    endif
    convert_t90_to_date,mjdt_now, $
         year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt
    date_str1=string(dom,cmonth,format="(i2.2,a3)")
    date_str2=string(hour,minutes,format="(i2.2,':',i2.2)")
    print, date_str1, '  ',date_str2
  endfor  
  
  extra_par=create_struct({xticks:nticks-1,xtickno:nticks-1,$
		          xtickv:xtickvals}, $
                          extra_par)
  
  plot, [starttime, endtime], [0,1], _extra=extra_par, /NODATA
  
  print,!X.crange
  
  ;not set plot with old range
  extra_par.xrange=old_range
  extra_par.ystyle=5
  plot, old_range, [0,1], XSTYLE=5,YSTYLE=5, $
    xrange=old_range,yrange=extra_par.yrange, /NODATA
  print,!X.crange
  
  down=0
  
end


