; program to read a list of email addresses from a file and to format
; them into majordomo subscribe format
pro papco_join_mailinglist
  
  path=papco_getenv('PAPCO_PATH')
  path=strmid(path,0,strlen(path)-1) + '_doc/mailing_list/'
  fln='new_subs.txt'
  instr='' & c=0 & buffer=strarr(600,2)
  openr,u,path+fln,/get_lun
  
  while not eof(u) do begin
    readf,u,instr
    
    result=str_sep(instr,'(')
    
    if n_elements(result) eq 1 then begin
      email=strtrim(result(0),2)
      res=str_sep(email,'@')
      name=res(0)
    endif else begin
      email=strtrim(result(0),2)
      name=strmid(result(1),0,strlen(result(1))-1)
    endelse
    
    newname=''
    nameparts=strtrim(str_sep(name,'.'),2)
    for i=0,n_elements(nameparts)-1 do begin
      a=strmid(nameparts(i),0,1)
      b=strmid(nameparts(i),1,strlen(nameparts(i)))
      newname=newname+strupcase(a)+b+' '
    endfor  
    
    buffer(c,0)=email
    buffer(c,1)=strtrim(newname,2)
    c=c+1
        
  endwhile 
  
  close,u & free_lun,u
  
  ;delete any doubles
  buffer=buffer(0:c-1,*)
  newbuf=strarr(c,2)
  newbuf(0,*)=buffer(0,*)
  k=0 & n=0
  
  for i=1,c-1 do begin
    k=k+1
    newbuf(k,*)=buffer(i,*)
    for j=0,k do if newbuf(k,0) eq newbuf(j,0) then n=n+1
    if n gt 1 then k=k-1
    n=0
  endfor
  newbuf=newbuf(0:k,*)
  
  ;write output file 
  fln='majordomo_commands.txt'
  openw,u,path+fln,/get_lun
  
  for i=0,k do begin
    outstr=strFormat(buffer(i,0),40,/LEFT) + '    (' + buffer(i,1) + ')'
    print, i,'  ',outstr  
    printf,u,'approve durban subscribe papco ',$
      buffer(i,0),' (' + buffer(i,1) + ')'
  endfor  
  
  close,u
  free_lun,u
  
end  

pro papco_tidelist
  
  path=papco_getenv('PAPCO_PATH')
  path=strmid(path,0,strlen(path)-1) + '_doc/mailing_list/'
  fln='tide_list.txt'
  instr='' & c=0
  openr,u,path+fln,/get_lun
  
  while not eof(u) do begin
    readf,u,instr
    
    result=strpos(instr,'@')
    index=where(result ne -1,count)
    if count ne 1 then goto, next
    
    result=strtrim(str_sep(instr,','),2)
    email=result(n_elements(result)-1)
    name=result(0)
    newname=name
    
    ;result=str_sep(instr,'(')
   ; 
   ; if n_elements(result) eq 1 then begin
   ;   email=strtrim(result(0),2)
   ;   res=str_sep(email,'@')
   ;   name=res(0)
   ; endif else begin
   ;   email=strtrim(result(0),2)
   ;   name=strmid(result(1),0,strlen(result(1))-1)
   ; endelse
   ; 
   ; newname=''
   ; nameparts=strtrim(str_sep(name,'.'),2)
   ; for i=0,n_elements(nameparts)-1 do begin
   ;   a=strmid(nameparts(i),0,1)
   ;   b=strmid(nameparts(i),1,strlen(nameparts(i)))
   ;   newname=newname+strupcase(a)+b+' '
   ; endfor  
   ; 
                                ;
    outstr=email + '    (' + strtrim(newname,2) + ')'
    
    c=c+1
    print, outstr
    
    next:
    
  endwhile 
  
  close,u
  free_lun,u
  
end  
