; This file is part of the PAPCO software package. 
;
; PAPCO is a free IDL package to combine data plots written and
; maintained by A. Keese and R. Friedel.
;                                                           
;    For more information, check the papco home page at     
;    http://leadbelly/ccr/software/papco/papco.html       
;    for online Manual and downloadble latest version.      
;                                                           
; Comments and questions can be directed to friedel@lanl.gov  
;  
; You are free to modify and distribute this file. However, and
; changes not communicated to R. Friedel will not become part of the
; next release of PAPCO.
;+
; NAME:
;     PAPCO_MK_HTML_HELP
;
; PURPOSE:
;     This procedure makes a set of html web documentation files
;     for the PAPCO software package.
;
; CATEGORY:
;     Documentation
;
; CALLING SEQUENCE:
;     Write the calling sequence here. Include only positional parameters
;     (i.e., NO KEYWORDS). For procedures, use the form:
;
;     ROUTINE_NAME, Parameter1, Parameter2, Foobar
;
;     Note that the routine name is ALL CAPS and arguments have Initial
;     Caps.  For functions, use the form:
; 
;     Result = FUNCTION_NAME(Parameter1, Parameter2, Foobar)
;
;     Always use the "Result = " part to begin. This makes it super-obvious
;     to the user that this routine is a function!
;
; INPUTS:
;     Parm1:  Describe the positional input parameters here. Note again
;     	      that positional parameters are shown with Initial Caps.
;
; OPTIONAL INPUTS:
;     Parm2:  Describe optional inputs here. If you don't have any, just
;     	      delete this section.
;     
; KEYWORD PARAMETERS:
;     INFO:   Calls doc_library to display this header documentation.
;             1: print to terminal, 2: print to default printer
;     VERB:   Set to display informational messages.
;     KEY1:   Document keyword parameters like this. Note that the keyword
;     	      is shown in ALL CAPS!
;
;     KEY2:   Yet another keyword. Try to use the active, present tense
;             when describing your keywords.  For example, if this keyword
;             is just a set or unset flag, say something like:
;             "Set this keyword to use foobar subfloatation. The default
;             is foobar superfloatation."
;
; OUTPUTS:
;     Describe any outputs here.  For example, "This function returns the
;     foobar superflimpt version of the input array."  This is where you
;     should also document the return value for functions.
;
; OPTIONAL OUTPUTS:
;     Describe optional outputs here.  If the routine doesn't have any, 
;     just delete this section.
;
; COMMON BLOCKS:
;     BLOCK1:	Describe any common blocks here. If there are no COMMON
;               blocks, just delete this entry.
;
; SIDE EFFECTS:
;     Describe "side effects" here.  There aren't any?  Well, just delete
;     this entry.
;
; RESTRICTIONS:
;     Describe any "restrictions" here.  Delete this section if there are
;     no important restrictions.
;
; PROCEDURE:
;     You can describe the foobar superfloatation method being used here.
;     You might not need this section for your routine.
;
; EXAMPLE:
;     Please provide a simple example here. An example from the PICKFILE
;     documentation is shown below. Please try to include examples that
;     do not rely on variables or data files that are not defined in
;     the example code. Your example should execute properly if typed
;     in at the IDL command line with no other preparation.
;
;     Create a PICKFILE widget that lets users select only files with 
;     the extensions 'pro' and 'dat'.  Use the 'Select File to Read' title 
;     and store the name of the selected file in the variable F.  Enter:
;
;	  F = PICKFILE(/READ, FILTER = ['pro', 'dat'])
;
; MODIFICATION HISTORY:
;     Written by:  Reiner Friedel, November 2001 
;-

PRO papco_mk_html_help, INFO = INFO, VERB = VERB 

  IF keyword_set(INFO) THEN BEGIN
      IF info EQ 2 THEN print = 1 ELSE print = 0
      doc_library, 'papco_mk_html_help', print = print
      return
  ENDIF

  papco_www = getenv('WWW_PAPCO')

  papco_lib = getenv('PAPCO_LIB')
  mk_html_help, papco_lib, papco_www+'/papco_lib_doc.html', $
    title = 'Documentation for PAPCO LIB routines',  verbose = verb

  papco = getenv('PAPCO_PATH')
  mk_html_help, papco, papco_www+'/papco_main_doc.html', $
    title = 'Documentation for PAPCO routines',  verbose = verb
  

END
