pro plot_gap, daten, ndat, $
              _EXTRA=e, $
              channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value, $
              noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
              zvalue=zvalue, nsum=nsum, polar=polar, thick=thick

   if not keyword_set(channel) then channel=!p.channel
   if not keyword_set(clip) then clip=0
   if not keyword_set(color) then color=!p.color
   if not keyword_set(linestyle) then linestyle=0
   if not keyword_set(noclip) then noclip=1
   if not keyword_set(psym) then psym=0
   if not keyword_set(symsize) then symsize=1.0
   if not keyword_set(t3d) then t3d=0
   if not keyword_set(zvalue) then zvalue=0
   if not keyword_set(polar) then polar=0
   if not keyword_set(nsum) then nsum=0
   if not keyword_set(thick) then thick=1.0

   if not keyword_set(xrange) then xrange=[0, ndat-1]
   if not keyword_set(yrange) then begin
      ymin=min(daten(xrange(0):xrange(1)))
      ymax=max(daten(xrange(0):xrange(1)))
      yrange=[ymin, ymax]
   endif

   if not keyword_set(max_value) then max_value=yrange(1)

   plot, daten,  /nodata, xrange=xrange, yrange=yrange,$
                 _EXTRA=e, $
                 channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value,$
                 noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
                 zvalue=zvalue, nsum=nsum, polar=polar, thick=thick


   i=0
   j=-1

   s=where(daten ne 0)
   anz=size(s)
   t=intarr(anz(3))

   while (i+1 lt anz(3)-1) do begin
      j=-1
      while ((i+1 lt anz(3)-1) and (s(i)+1 eq s(i+1))) do begin
         j=j+1
         t(j)= s(i)
         i=i+1
      endwhile
      
      if(j ge 0) then begin
         u=t(0:j)
         oplot, u, daten(u), $
                channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value,$
                noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
                zvalue=zvalue, nsum=nsum, polar=polar, thick=thick
                             
      endif
      
      i=i+1
   endwhile
   
end


pro plot_io_gap, daten, ndat, $
              _EXTRA=e, $
              channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value, $
              noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
              zvalue=zvalue, nsum=nsum, polar=polar, thick=thick

   if not keyword_set(channel) then channel=!p.channel
   if not keyword_set(clip) then clip=0
   if not keyword_set(color) then color=!p.color
   if not keyword_set(linestyle) then linestyle=0
   if not keyword_set(noclip) then noclip=1
   if not keyword_set(psym) then psym=0
   if not keyword_set(symsize) then symsize=1.0
   if not keyword_set(t3d) then t3d=0
   if not keyword_set(zvalue) then zvalue=0
   if not keyword_set(polar) then polar=0
   if not keyword_set(nsum) then nsum=0
   if not keyword_set(thick) then thick=1.0

   if not keyword_set(xrange) then xrange=[0, ndat-1]
   if not keyword_set(yrange) then begin
      ymin=min(daten(xrange(0):xrange(1)))
      ymax=max(daten(xrange(0):xrange(1)))
      yrange=[ymin, ymax]
   endif

   if not keyword_set(max_value) then max_value=yrange(1)

   plot, daten,  /nodata, xrange=xrange, yrange=yrange,$
                 _EXTRA=e, $
                 channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value,$
                 noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
                 zvalue=zvalue, nsum=nsum, polar=polar, thick=thick


   i=0
   j=-1

   s=where(daten ne 0)
   anz=size(s)
   t=intarr(anz(3))

   while (i+1 lt anz(3)-1) do begin
      j=-1
      while ((i+1 lt anz(3)-1) and (s(i)+1 eq s(i+1))) do begin
         j=j+1
         t(j)= s(i)
         i=i+1
      endwhile
      
      if(j ge 0) then begin
         u=t(0:j)
         oplot, u, daten(u), $
                channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value,$
                noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
                zvalue=zvalue, nsum=nsum, polar=polar, thick=thick
                             
      endif
      
      i=i+1
   endwhile
   
end


pro plot_ngap, daten, ndat, $
              _EXTRA=e, $
              channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value, $
              noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
              zvalue=zvalue, nsum=nsum, polar=polar, thick=thick

   if not keyword_set(channel) then channel=!p.channel
   if not keyword_set(clip) then clip=0
   if not keyword_set(color) then color=!p.color
   if not keyword_set(linestyle) then linestyle=0
   if not keyword_set(noclip) then noclip=1
   if not keyword_set(psym) then psym=0
   if not keyword_set(symsize) then symsize=1.0
   if not keyword_set(t3d) then t3d=0
   if not keyword_set(zvalue) then zvalue=0
   if not keyword_set(polar) then polar=0
   if not keyword_set(nsum) then nsum=0
   if not keyword_set(thick) then thick=1.0

   if not keyword_set(xrange) then xrange=[0, ndat-1]
   if not keyword_set(yrange) then begin
      ymin=min(daten(xrange(0):xrange(1)))
      ymax=max(daten(xrange(0):xrange(1)))
      yrange=[ymin, ymax]
   endif

   if not keyword_set(max_value) then max_value=yrange(1)



   ; Koordinatensystem plotten
   plot, daten,  /nodata, xrange=xrange, yrange=yrange,$
                 _EXTRA=e, $
                 channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value,$
                 noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
                 zvalue=zvalue, nsum=nsum, polar=polar, thick=thick


   i=0
   j=-1

   s=where(daten ne 0)
   anz=size(s)
   t=intarr(anz(3))

   ; Linie von 0 zum ersten Punkt ungleich 0 plotten
   if(daten(0) eq 0) then begin
      u=[0, s(0)]
      oplot, u, daten(u)
   endif

   ; Plotabschnitte mit Werten ungleich 0 suchen
   while (i+1 lt anz(3)-1) do begin
      j=-1
      while ((i+1 lt anz(3)-1) and (s(i)+1 eq s(i+1))) do begin
         j=j+1
         t(j)= s(i)
         i=i+1
      endwhile
      
      ; Plotabschnitte mit Werten ungleich 0 plotten
      if(j ge 0) then begin
         u=t(0:j)
         oplot, u, daten(u), $
                channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value,$
                noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
                zvalue=zvalue, nsum=nsum, polar=polar, thick=thick
                             
      endif
      
      ; Verbindungslinie zwischen den Plotabschnitten herstellen
      if(s(i+1) ne s(i)+1) then begin
         if i ne 0 then u=[s(i-1), s(i+1)] else u=[s(i), s(i+1)]
         oplot, u, daten(u), $
                channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value,$
                noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
                zvalue=zvalue, nsum=nsum, polar=polar, thick=thick

      endif

      i=i+1
   endwhile

   ; Linie vom letzten Punkt ungleich 0 zum letzten Punkt
   if(daten(ndat-1) eq 0) then begin
      u=[s(anz(3)-1), ndat-1]
      oplot, u, daten(u), $
             channel=channel, clip=clip, color=color, linestyle=linestyle, max_value=max_value,$
             noclip=noclip, psym=psym, symsize=symsize, t3d=t3d, $
             zvalue=zvalue, nsum=nsum, polar=polar, thick=thick
   endif

   
end











