PRO r_onera_Lstar, SAT = SAT, NAME = NAME,  DATE1 = DATE1, DATE2 = DATE2

COMMON mjdt, mjdt_start, mjdt_end
COMMON get_error, get_err_no, get_err_msg

;format of L-star files
;
;Time (decimal year)  L-McIlwain   L*  Bm(nT)   Bequ(nT)   I   MLT(hr)

papco, /set_only

IF keyword_set(SAT) THEN sat = strupcase(SAT) ELSE sat = 'GPS'
IF keyword_set(NAME) THEN name = NAME ELSE name = 'ns33'

;get list of available ephemeris savesets
CASE sat OF
    'GPS': BEGIN
        COMMON gps_eph_data, input_header, input_data
        COMMON lanl_gps
        COMMON gps_eph_1, gps_eph_sat_id, gps_eph_eph_names, $
                          gps_eph_select_names, gps_eph_control
        IF NOT papco_check_data_env('GPS_EPH_DATA', PATH=path) THEN return
        p1 = path+name+'/????????_'+name+'.eph'
        files1 = papco_file_search(p1, count = c1)
        dates1 = long(strmid(files1, strlen(path+name+'/'), 8))
        p2 = path+name+'/new_lstar/'+name+'???????.L.gz'
        files2 = papco_file_search(p2, count = c2)
        dates2 = strmid(files2,strlen(path+name+'/new_lstar/'+name)+1, 6)
        ;make plotinfo structure for read
        new_plotinfo = papco_getplotinfostruct()
        new_control = gps_eph_control
        idx = where(gps_eph_sat_id EQ name)
        new_control.sc_id = idx(0)
        new_control.product = 0 ;choose L, arbitrary here
        new_control.orig = 1 ;model coords
        new_control.internal_model = 0 ;IGRF 
        new_control.external_model = 5 ;Olson Pfitzer quiet 77
        new_plotinfo.USR_PTR1 = ptr_new(new_control)
    END
    'GEO':BEGIN
        COMMON geo_eph_data, geo_eph_header, geo_eph_data
        COMMON lanl_geo_eph, geo_sat_names, geo_eph_names, geo_yunits, $
                             geo_eph_control
        IF NOT papco_check_data_env('GEO_EPH_DATA', PATH=path) THEN return
        p1 = path+'????/????????_'+name+'_eph.idl'
        files1 = papco_file_search(p1, count = c1)
        dates1 = long(strmid(files1, strlen(path)+5, 8))
        p2 = path+'????/new_lstar/??????_'+name+'.L.gz'
        files2 = papco_file_search(p2, count = c2)
        dates2 = strmid(files2,strlen(path)+15, 6)
        ;make plotinfo structure for read
        new_plotinfo = papco_getplotinfostruct()
        new_control = geo_eph_control
        idx = where(geo_sat_names EQ name)        
        new_control.sc_id = idx(0)
        new_control.product = 0 ;choose L, arbitrary here
        new_control.orig = 1 ;model coords
        new_control.internal_model = 0 ;IGRF 
        new_control.external_model = 5 ;Olson Pfitzer quiet 77
        new_plotinfo.USR_PTR1 = ptr_new(new_control)        
    END     
    ELSE: BEGIN
        message, 'Satellite '+name+' not recognized', /info
        return
    END 
ENDCASE

;get dates of new_lstar files
idx = where(strmid(dates2, 0, 1) EQ '0', c)
IF c NE 0 THEN dates2(idx) = '20'+dates2(idx)
idx = where(strmid(dates2, 0, 1) EQ '9', c)
IF c NE 0 THEN dates2(idx) = '19'+dates2(idx)
dd = long(dates2)
idx = sort(dd) & dates2 = dates2(idx)

IF keyword_set(DATE1) THEN date1 = DATE1 ELSE date1 = dates2(0)
IF keyword_set(DATE2) THEN date2 = DATE2 ELSE date2 = dates2(c2-1)

idx = where((long(dates2) GE long(date1)) AND (long(dates2) LE long(date2)),c2)
IF c1 EQ 0 THEN BEGIN
    message, 'No data for date range requested', /info
    return
ENDIF 

dates2 = dates2(idx)

FOR i = 0, c2-1 DO BEGIN
    print, ''
    result = convert_timeToSeconds(dates2(i), /t90, /mjdt)
    mjdt = result.value

    tai_1=utc2tai({mjd:mjdt.mjd, time:mjdt.t*1000})
    r = tai2utc(tai_1, /EXTERNAL)
    st_sec = UTC2TAI({year:r.year, MONTH:1, DAY:1, $
                  HOUR:0, MINUTE:0, SECOND:0, MILLISECOND:0})
    en_sec = UTC2TAI({year:r.year+1, MONTH:1, DAY:1, $
                  HOUR:0, MINUTE:0, SECOND:0, MILLISECOND:0})
    year_sec = en_sec-st_sec
    year_str = string(r.year, format = "(i4.4)")

    ;read lstar file
    dd = strmid(dates2(i), 2, 6)
    CASE sat OF
        'GPS': ff = path+name+'/new_lstar/'+name+'h'+dd+'.L'
        'GEO': ff = path+year_str+'/new_lstar/'+dd+'_'+name+'.L'
    ENDCASE
    message, 'Reading new L Star data ', /info
    print, '  ', ff
    spawn, 'gunzip '+ff+'.gz'
    openr, u, ff, /get_lun
    dmy1 = {dy:0.0d, lm:0.0,ls:0.0, bm:0.0, bq:0.0, is:0.0, mlt:0.0}
    dmy2 = create_struct('tai', 0.0d, dmy1) 
    new_l = replicate(dmy2, 10000)
    ii = 0
    WHILE NOT eof(u) DO BEGIN 
        readf, u,  dmy1
        dmy2 = create_struct('tai', 0.0d, dmy1) 
        dmy2.tai = st_sec + (dmy1.dy - r.year) * year_sec
        new_l(ii) = dmy2
        ;print, ii, '  ', tai2utc(dmy2.tai,/ecs)
        ii = ++ii
    ENDWHILE  
    close, u & free_lun, u
    spawn, 'gzip '+ff
    IF ii EQ 0 THEN continue
    new_l = new_l(0:ii-1)
    new_lstar = new_l.ls
    idx = where(new_lstar EQ 100.0, c)
    IF c NE 0 THEN new_lstar(idx) = -99.0

    CASE sat OF
        'GPS': BEGIN
            ;loop through next 7 days to read existing ephemeris.
            this_mjdt = mjdt & idx1 = 0
            FOR ii = 0, 6 DO BEGIN
                r_gps_eph_onefile, new_plotinfo, this_mjdt
                n1 = n_elements(input_data)
                idx2 = idx1+n1-1
                print, n1, idx1, idx2
                input_data.model_0_5.LSTAR = new_lstar(idx1:idx2)
                r_gps_eph_onefile, new_plotinfo, this_mjdt, /SAVE
                this_mjdt.mjd = this_mjdt.mjd+1
                idx1 = idx1+n1
            ENDFOR 
        END
        'GEO':BEGIN
            this_mjdt = mjdt
            r_geo_eph_one, new_plotinfo, this_mjdt
            geo_tai = geo_eph_data.tai
            new_tai = new_l.tai
            new_lstar = papco_interpol(new_lstar,new_tai,geo_tai,nodata=-99)
            idx = where(geo_eph_data.MODEL_0_5.l EQ -10, c)
            IF c NE 0 THEN new_lstar(idx) = -99.0
            geo_eph_data.MODEL_0_5.lstar = new_lstar
            r_geo_eph_one, new_plotinfo, this_mjdt, /SAVE
        END
    ENDCASE 

ENDFOR


END
