pro rf_plot,tmin,xray,yray,_EXTRA=e

;a wrapper routine to the build-in plot_io routine to allow plotting of 
;non-time monotonic data arrays. That is arrays with data missing for
;various time periods. Where there is data they are plotted, otherwise
;nothing is plotted. Parameters are exactly the same as for plot_io,
;however xarray and yarray must be given.

;find normal time between data points. Defined as minimum time bewteen any
;two data points.

   common test,xrr

   x=xray & y=yray

   zind=where(y ne 0,count)
   if count gt 0 then begin
      x=x(zind) & y=y(zind)
   endif

   n=n_elements(x)

   if n lt 2 then goto,out
   xraydiff=x(1:n-1)-x(0:n-2)
   tmax=max(xraydiff)
;  print,min(xraydiff),'  tmin:',tmin,'   tmax:',tmax,' n:',n
   if (tmax eq 0) then goto,out

;loop: plot only those sections where tdiff between two datapoints is 
;      less than tmin*1.5

   bindex=where(xraydiff ge 1.5*tmin,count)
;  print,count,bindex

   if count ge 1 then begin
      startindex = [0,bindex+1] ;add zero or front index
      endindex   = [bindex,n-1] ;add last index

      length=endindex-startindex
      lindex=where(length gt 1,cc)
      if cc gt 1 then begin
         startindex=startindex(lindex)
         endindex=endindex(lindex)
      endif
      count=n_elements(startindex)-1
   endif

   if count ge 1 then begin
      for j=0,count do begin  
;        print,startindex(j),endindex(j)
         xpart=x(startindex(j):endindex(j))
         ypart=y(startindex(j):endindex(j))
         plot,xpart,ypart,_EXTRA=e
      endfor
   endif else begin
      plot,x,y,_EXTRA=e
   endelse

out:

end

; wrapper program to the idl oplot, to do oplots but not connect large gaps with 
; lines 

pro gap_oplot,x,y,_EXTRA=e

; first remove all data invalid points
 
   ndat=n_elements(x) 
   index=where(y ne 0,count)
   if count ne 0 then begin
      xray=x(index)
      yray=y(index)
   endif

; work out average spacing along time axis. If actual spacing encountered is
; more than three times the average, don't plot.

   ndat=n_elements(xray)
   diff_time=abs(xray(1:ndat-2) - xray(0:ndat-1))
   av_int=total(diff_time)/(n_elements(diff_time))

   diff_y=abs(yray(1:ndat-2) - yray(0:ndat-1))
   av_y=total(diff_y)/(n_elements(diff_y))

; work out jumps in y. If a jump is larger than 5 times the average, don't plot

   for i=0,ndat-2 do begin
      int=abs(xray(i+1)-xray(i))
      if int lt av_int*3 then begin
         inty=abs(yray(i+1)-yray(i))
         if inty lt av_y*5 then begin
            plots,xray(i),yray(i) 
            plots,xray(i+1),yray(i+1),/continue,noclip=0,_EXTRA=e
         endif
      endif
    endfor

end




