pro rf_plot_io,tmin,xray,yray,_EXTRA=e

;a wrapper routine to the build-in plot_io routine to allow plotting of 
;non-time monotonic data arrays. That is arrays with data missing for
;various time periods. Where there is data they are plotted, otherwise
;nothing is plotted. Parameters are exactly the same as for plot_io,
;however xarray and yarray must be given.

;find normal time between data points. Defined as minimum time bewteen any
;two data points.

common matches, injpoints
common test, xr
zindex=where(xray ne 0,count)
injpoints=count
if count gt 0 then begin
  xray=xray(zindex)
  yray=yray(zindex)
endif

n=n_elements(xray) ;& print,n,' <<-'
xr=xray

if n lt 2 then goto,out
xraydiff=xray(1:n-1)-xray(0:n-2)
tmax=max(xraydiff)
;print,min(xraydiff),'  tmin:',tmin,'   tmax:',tmax,' n:',n
if (tmax eq 0) then goto,out

;loop: plot only those sections where tdiff between two datapoints is 
;less than tmin*1.5

bindex=where(xraydiff ge 1.5*tmin,count)
;print,count,bindex

if count ge 1 then begin
  startindex = [0,bindex+1]        ;add zero or front index
  endindex   = [bindex,n-1]    ;add last index

  length=endindex-startindex
  lindex=where(length gt 1,cc)
  if cc gt 1 then begin
    startindex=startindex(lindex)
    endindex=endindex(lindex)
  endif
  count=n_elements(startindex)-1
endif

if count ge 1 then begin
  for j=0,count do begin  
;    print,startindex(j),endindex(j)
    xpart=xray(startindex(j):endindex(j))
    ypart=yray(startindex(j):endindex(j))
    plot_io,xpart,ypart,_EXTRA=e
  endfor
endif else begin
  plot_io,xray,yray,_EXTRA=e
endelse

out:

end
