;******************************************************************************
;* PROCEDURE:
;*       pro set_device
;*
;* DESCRIPTION:
;*       used by papco system. Reads the common widgetData.land_port to see
;*       if landscape or portrait mode is chosen. Sets gif size and print font
;*       size from defaults in widgetdata.
;*
;*       reads the IDL graphics variable !d.name which is set by the
;*       routine set_plot from the IDL prompt. set_plot='x', the
;*       default when starting IDL, selects and X-window
;*       display. set_plot='ps' selects postscript output.
;*       Here display and plot window size are set.
;*
;* INPUTS:
;*	plfl    :   Plot output filename
;*
;* KEYWORDS:
;*	SLICE   ;  indicates plot is from a slice window, needs
;*                 different siizing
;*
;* OUTPUT:
;*      none
;*
;* CALLING EXAMPLE:
;*      set_device,plfl
;*
;* MODIFICATION HISTORY:
;*      April 1998, written by R. Friedel
;******************************************************************************
pro set_device,plfl, SLICE=SLICE

  COMMON PLOT_COMPOSER, widgetData

  if keyword_set(SLICE) then slice=SLICE else slice='papco'

; select output paper sizes according to US_EUROPE
  if widgetData.default_US_EUROPE eq 0 then begin ; A4 paper size
    if slice eq 'papco' then begin  ;sizing for papco panel output
      xoffset=0.2 &  yoffset=0.2
      xsize=7.8   &  ysize=11.2
    endif else begin                ;sizing for papco slice output
      xoffset=0.2 &  yoffset=0.2
      xsize=7.8   &  ysize=11.2
    endelse
  endif else begin                        ; US letter size
    if slice eq 'papco' then begin  ;sizing for papco panel output
      xoffset=0.2 &  yoffset=0.2
      xsize=7.8   &  ysize=10.5
    endif else begin                ;sizing for papco slice output
      xoffset=0.5 &  yoffset=2.0
      ;xoffset=0.5 &  yoffset=-2.0
      xsize=7.5   &  ysize=6.5
      ;xsize=7.5*0.947   &  ysize=6.5*2.06
    endelse
  endelse

  erase

  if widgetData.default_layout eq 0 then begin
    message,'plot device is portrait',/cont
    case !d.name of
    'X' :
    'PS': BEGIN
      !P.CHARSIZE=!P.CHARSIZE*widgetData.default_ps_mult
      device, /inches, /color, bits=8, filename=plfl, $
        xoffset=xoffset, yoffset=yoffset, xsize=xsize, ysize=ysize, $
        encapsulated=widgetData.default_ps_eps, landscape=0
    end
    'PRINTER': BEGIN
      !P.CHARSIZE=!P.CHARSIZE*widgetData.default_ps_mult
      device, /inches,  $
        xoffset=xoffset, yoffset=yoffset, xsize=xsize, ysize=ysize, landscape=0
    end
    'Z' : begin
      if  widgetdata.default_png_format eq 0 then begin ;output full page
        x_gif=widgetData.default_gif_size(0)
        y_gif=widgetData.default_gif_size(1)
        device, set_resolution=[x_gif,y_gif], $
          set_character_size=[x_gif/120, x_gif/72]*!P.CHARSIZE
      endif else begin            ;output individual panels
        if widgetdata.default_png_format eq 1 then $
          x_gif=1440 / 0.675 else $
          x_gif=widgetData.default_gif_size(0)
        y_gif=widgetdata.numberOfPlots*200 / $
          (0.875-widgetdata.numberOfPlots*0.005)
        device, set_resolution=[x_gif,y_gif], $
          set_character_size=[x_gif/120, x_gif/72]*!P.CHARSIZE
      endelse
    end
    endcase

  endif else begin
     message,'plot device is landscape', /cont
     case !d.name of
    'X' :
    'PS': begin
       !P.CHARSIZE=!P.CHARSIZE*widgetData.default_ps_mult
       device,/inches, /color, bits=8, filename=plfl, $
         xoffset=xoffset, yoffset=yoffset+ysize, xsize=ysize, ysize=xsize, $
         encapsulated=widgetData.default_ps_eps,landscape=1
    end
    'PRINTER': begin
       !P.CHARSIZE=!P.CHARSIZE*widgetData.default_ps_mult
       device,/inches, $
         xoffset=xoffset, yoffset=yoffset+ysize, xsize=ysize, ysize=xsize, $
         landscape=1
    end
    'Z' : begin
       x_gif=widgetData.default_gif_size(1)
       y_gif=widgetData.default_gif_size(0)
       device, set_resolution=[x_gif,y_gif], $
        set_character_size=[ y_gif/120, y_gif/72 ]*!P.CHARSIZE
    end
    endcase

  endelse

end
