; List Control Widget 
;
; Provides GUI method of creating and maintaining lists.
;
; Notes:
;    The list, created with xx_listman, must have its elements
; contain the structure tags:
;    { value:'',         ; which is what the list manages, and
;      handle:0L }       ; which is used to identify sets of elements.
;
;    The list must have a header which contains:
;    { handle_active:intarr(100) } ; which is used for handle allocation.
;
;
; Written January 16, 1998 Jeremy Faden
;

pro papco_slice_control_help
  text= $
    [ 'Slice List.', $
      'The "slice_list" list widget shows the list of slices to be drawn.', $
      'One may select items from this list by clicking on the list item.  This', $
      'item is then copied to the "selection" text widget, described below.', $
      '', $
      'Selection.', $
      'This widget is where one enters the argument for the Add, Delete, and', $
      'Control buttons below.  For instance, to add a time, enter the time, and', $
      'then click "add."  The time entered appears in the slice list.  ', $
      '', $
      'Add.  ', $
      'The selection time is added to the list.', $
      '', $
      'Delete. ', $
      'The selection time is deleted from the list.  One typically would use the', $
      'slice list widget to select a time, then Delete deletes that time.', $
      '', $
      'Delete Series.', $
      'The series identifier in the selection, a number enclosed in [brackets], ', $
      'identifies the series for which all members are deleted.  "Add series" ', $
      'generates items with series identifiers.', $
      '', $
      'Add Series.', $
      'Adds a series of items, the first is at "Series Start Time", in increments', $
      'of "Series Increment", up to "Series End Time".  The series appears on the ', $
      'slice list with a series identifier.', $
      '', $
      'Dismiss.', $
      'Closes the widget.', $
      '' $
    ]
  x= widget_message( text )
end


pro papco_slice_control_event, ev

  forward_function convert_SecondsToTime
  forward_function convert_TimeToSeconds

  widget_control, ev.top, get_uvalue=widget_Data
  widget_control, ev.id, get_uvalue=uvalue 
  widget_control, widget_data.value_ID, get_value=valuestr
  valuestr= valuestr(0)

; parse input, looking for series handle specification
  ss= str_sep( valuestr, '[' )
  if n_elements( ss ) gt 1 then begin
      valuestr=ss(0)
      handle= long( ss(1) )
  endif else begin
      handle= -1
  endelse

  if widget_Data.valueIsTime then begin
      zz=  convert_TimeToSeconds( valuestr, /t90 )
      if handle eq -1 then handlestr='' else handlestr= ' ['+ss(1)
      if ( zz.err eq 0 ) then begin
          valuestr= convert_SecondsToTime( zz.value, /t90, country=1 )
          widget_control, widget_data.value_ID, $
            set_value= valuestr+handlestr
      endif 
  endif
        
  listID= widget_Data.listID

  case uvalue of 
      'pb_add': begin
          papco_slice_listman, listID, vv, /get_type
          vv.value= valuestr
          vv.input= slice_get_input_structure( valuestr )
          papco_slice_listman, listID, vv, /add
      end
      'pb_delete': begin
          papco_slice_listman, listID, valuestr, tag_delete='value'
          papco_slice_listman, listID, vv, /next_retrieve
          if n_elements( vv ) gt 0 then begin
              widget_control, widget_data.value_ID, $
                set_value= string( vv.value )
          endif else begin
              widget_control, widget_data.value_ID, set_value=''
          endelse
      end
      'pb_delete_series': begin
          if handle ne -1 then begin
              papco_slice_listman, listID, tag_delete='handle', handle
              papco_slice_listman, listID, /get_header, hh
              hh.handle_active(handle)=0
              papco_slice_listman, listID, /set_header, hh
          endif
      end
      'list_input': begin
          idx= ev.index
          papco_slice_listman, listID, set_index= idx
          papco_slice_listman, listID, values, /retrieve
          if n_elements( values ) gt 0 then begin
              valuestr= string(values(idx).value)
              if ( values(idx).handle gt 0 ) then  $
                valuestr= valuestr + ' [' + strtrim(values(idx).handle,2) + ']'
              widget_control, widget_data.value_ID, $
                set_value= valuestr
          endif
      end
      'time_input': begin
          if widget_data.mode_swittch eq 0 then begin
              papco_slice_listman, listID, vv, /get_type
              vv.value= valuestr
              vv.input= slice_get_input_structure( valuestr )
              papco_slice_listman, listID, vv, /add
          endif else begin 
              papco_slice_listman, tag_delete='value', value
          endelse
      end
      'pb_mode0': widget_data.mode_swittch=0
      'pb_mode1': widget_data.mode_swittch=1
      'series': 
      'pb_series': begin
;        get start time
          widget_control, widget_data.series_in_ID, get_value=timestr
          zz1= convert_TimeToSeconds( timestr(0), /t90 )
;        get end time
          widget_control, widget_data.series_out_ID, get_value=timestr
          zz2= convert_TimeToSeconds( timestr(0), /t90 )
;        get increment (seconds)
          widget_control, widget_data.series_delta_ID, get_value=delta
;        in, out, delta define the series
          in= zz1.value
          out= zz2.value
          delta= long( delta )

;        add series to the list
          if zz1.err+zz2.err eq 0 then begin
              papco_slice_listman, listID, hh, /get_header
              handle_active= hh.handle_active ; allocate handle
              r= where( handle_active eq 0 )
              if r(0) ne -1 then begin
                  handle= r(0)
                  hh.handle_active(handle)=1
                  papco_slice_listman, listID, hh, /set_header
                  papco_slice_listman, listID, vv, /get_type
                  n= long( ( out-in ) / delta ) +1 < 100
                  series= replicate( vv, n )
                  series(*).handle= handle
                  for i=0,n-1 do begin
                      val= in + delta*i
                      valstr= convert_SecondsToTime( val, /t90, country=1 )
                      series(i).value= valstr
                      series(i).input= slice_get_input_structure( valstr )
                  endfor
                  papco_slice_listman, listID, series, /add
              endif else begin
                  r= widget_message( ['All series handles','are allocated.'] )
              endelse
          endif else begin
              r= widget_message( ['Error in','time format.' ] )
          endelse
      end
      'pb_dismiss': begin
          widget_control, widget_data.base_ID, /destroy
          return
      end
      'pb_help': begin
          papco_slice_control_help
          return
      end
      'pb_control': begin
          papco_slice_listman, listID, list, /retrieve
          r= where( list.value eq valuestr )
          if r(0) ne -1 then begin
              input= list(r(0)).input 
              slice_input_control, input, group= ev.top
              list(r(0)).input= input
              papco_slice_listman, listID, list, /store
          endif else begin
              widget_control, widget_data.value_id, $
                set_value='Not found in list.'
              wait, 1
              widget_control, widget_data.value_id, $
                set_value=valuestr
          endelse
      end

;          slice_rw_list, /read, species, header, data, input_global
;          r= where( abs( data(*).time - t90 ) lt 1.0 )
;          if r(0) ne -1 then begin
;              input= data(r(0)).input
;              state= input
;              species_store= input.species
;              if species eq 0 then $
;                control_ele= input.control $
;              else $
;                control_ion= input.control 
;              control, input
;              data(r(0)).input= input
;              data(r(0)).reload=1
;              if n_elements(out_header) gt 0 then $
;                out_header.reload(species)=1
;              slice_rw_list, /write, species, header, data, $
;                input_global
;          endif else begin
;              message, 'Couldn''t find time.', /cont
;              return
;          endelse
;      end
      else: begin
          message, 'unrecognized uvalue.', /cont
      end
  endcase
  

; reset list
  papco_slice_listman, listID, list, index=index, /retrieve
  if n_elements( list ) gt 0 then begin
      valuestr= string(list(*).value)
      r= where( list(*).handle gt 0)
      if r(0) ne -1 then begin
          valuestr(r)= valuestr(r) + ' [' + strtrim(list(r).handle,2) + ']'
      endif
  endif else begin
      valuestr= ['---']
  endelse
  widget_control, widget_data.list_ID, set_value= valuestr
  widget_control, widget_data.list_ID, set_list_select=index

  return
end

pro papco_slice_control, listID, value, $
                   group=group, valueIsTime=valueIsTime, title=title, $
                   index=index

; 
; creates the widget that controls the slice module.  Allows
; user to add and delete slices, and add or delete a series of
; slices.
;
; I/O:
;    listID        input   identifies which list to use.
;    value         input   put this value in the text window
;    /valueIsTime  input   values are PaPCo time strings and series utility
;                          is active
;    title=''      input   title of the widget

   forward_function convert_SecondsToTime
   forward_function convert_TimeToSeconds

   valueIsTime= keyword_set( valueIsTime )

   common time, xut1, xut2
   common papco_slice_control_common, widget_data, listID0

   if n_elements( xut1 ) gt 0 and valueIsTime then begin
       xut1str= convert_SecondsToTime( xut1, /t90, country=1)
       xut2str= convert_SecondsToTime( xut2, /t90, country=1)
   endif else begin
       xut1str=''
       xut2str=''
   endelse

;   create list automatically if listID is undefined.
   if n_elements( listID ) eq 0 then begin
       if n_elements( value ) eq 0 then begin
           vv= { value:'', handle:0, reload:1 }
       endif else begin
           vv= { value:value, handle:0, reload:1 }
       endelse
       handle_active= intarr(100)
       handle_active(0)=1
       papco_slice_listman, listID, vv, /create, $
         header= { handle_active:handle_active }
   endif

   
   if n_elements( listID0 ) eq 0 then listID0=-1
   
   if listID0 ne listID then begin
       if xregistered('papco_slice_control') then begin
           widget_control, widget_data.base_id, /destroy 
       endif
       widget_data= { papco_slice_control_widget_data_struct, $
                      base_ID:0L, $
                      value_ID:0L, $
                      list_ID:0L, $ ; list widget ID
                      series_in_ID:0L, $
                      series_in_val:xut1str, $
                      series_out_ID:0L, $
                      series_out_val:xut2str, $
                      series_delta_ID:0L, $
                      series_delta_val:'60', $
                      mode_swittch:0L, $
                      valueIsTime:0L, $
                      listID:0L $ ; identifies list
                    }
       listID0= listID
   endif
   
   widget_data.valueIsTime= valueIsTime
   widget_data.listID= listID

   if n_elements(value) gt 0 then begin
       if widget_data.mode_swittch eq 0 then begin
           papco_slice_listman, listID, /get_type, aType
           aType.value=value
           papco_slice_listman, listID, /add, aType
       endif else begin 
           papco_slice_listman, tag_delete='value', value
       endelse
   endif

   if xregistered('papco_slice_control') then begin
       if n_elements( value ) gt 0 then $
         widget_control, widget_data.value_ID, set_value= value
       
       if n_elements(index) gt 0 then begin
           idx=index
           papco_slice_listman, listID, set_index=ind
           papco_slice_listman, listID, values, /retrieve
           if n_elements( values ) gt idx then begin
               valuestr= string(values(idx).value)
               if ( values(idx).handle gt 0 ) then  $
                 valuestr= valuestr + ' [' + strtrim(values(idx).handle,2) + ']'
               widget_control, widget_data.value_ID, $
                 set_value= valuestr
           endif
       endif else begin       
           papco_slice_listman, listID, list, index=index, /retrieve
           if n_elements( list ) gt 0 then begin
               valuestr= string(list(*).value)
               r= where( list(*).handle gt 0)
               if r(0) ne -1 then begin
                   valuestr(r)= valuestr(r) + ' [' +strtrim(list(r).handle,2) + ']'
               endif
           endif else begin
               valuestr= ['---']
           endelse
           widget_control, widget_data.list_ID, set_value= valuestr
           widget_control, widget_data.list_ID, set_list_select=index
       endelse           
       return
   endif
   
   if not keyword_set( title ) then title= 'List Control ('+strtrim(listID,2)+')'
   
   control_base= papco_widget_base( title=title,group=group, /column )
   widget_data.base_ID= control_base
   
; time base allows user to add/delete specific time
   times_base= widget_base( control_base, /frame, /column )
   
   if n_elements( value ) eq 0 then valuestr='' else begin
       valuestr= string( value )
   endelse
   
   valuestr= ['---']
   x= widget_label( times_base, value='slice list' )
   r= widget_list( times_base, $
                   xsize=20, ysize=5, scr_xsize=160, value=valuestr, $
                   uvalue='list_input' )
   widget_data.list_ID=r

   x= widget_label( times_base, value='selection:' )
   r= widget_text( times_base, $
                   /edit, xsize=24, value=valuestr, $
                   uvalue='time_input' )
   widget_data.value_ID= r
   

   if n_elements(index) gt 0 then begin
       idx=index
       papco_slice_listman, listID, set_index=ind
       papco_slice_listman, listID, values, /retrieve
       if n_elements( values ) gt idx then begin
           valuestr= string(values(idx).value)
           if ( values(idx).handle gt 0 ) then  $
             valuestr= valuestr + ' [' + strtrim(values(idx).handle,2) + ']'
           widget_control, widget_data.value_ID, $
             set_value= valuestr
       endif
   endif

   
; reset list
  papco_slice_listman, listID, list, index=index, /retrieve
  if n_elements( list ) gt 0 then begin
      valuestr= string(list(*).value)
      r= where( list(*).handle gt 0)
      if r(0) ne -1 then begin
          valuestr(r)= valuestr(r) + ' [' + strtrim(list(r).handle,2) + ']'
      endif
  endif else begin
      valuestr= ['---']
  endelse
  widget_control, widget_data.list_ID, set_value= valuestr
  widget_control, widget_data.list_ID, set_droplist_select=index

; add/delete time and delete series button
   times_but_base= widget_base( times_base, /row )
   r= widget_button( times_but_base, value='Add', uvalue='pb_add' )
   r= widget_button( times_but_base, value='Delete', uvalue='pb_delete' )
   if (widget_data.valueIsTime) then $
     r= widget_button( times_but_base, value='Delete Series', $
                       uvalue='pb_delete_series' )
   r= widget_button( times_base, value='Control', uvalue='pb_control')

   if (widget_data.valueIsTime) then begin
; series base allows user to add delete a series
       series_base= widget_base( control_base, /frame, /column )
       r= widget_label( series_base, value='Series Start Time: ' )
       r= widget_text( series_base, $
                       /edit, xsize=20, value=widget_Data.series_in_val, $
                       uvalue='series' )
       widget_data.series_in_ID= r
       r= widget_label( series_base, value='Series End Time: ' )
       r= widget_text( series_base, $
                       /edit, xsize=20, value=widget_Data.series_out_val, $
                       uvalue='series' )
       widget_data.series_out_ID= r
       b= widget_base( series_base, /row )
       r= cw_field( series_base, $
                    title='Series Increment (sec): ', $
                    xsize=5, value=widget_Data.series_delta_val, $
                    uvalue='series', /float )
       widget_data.series_delta_ID= r
       r= widget_button( series_base, value='Add Series', uvalue='pb_series' )
   endif

   onelast_base= widget_base( control_base, /frame, /row )
   b= widget_button( onelast_base, value='Help', uvalue='pb_help' )
   b= widget_button( onelast_base, value='Dismiss', uvalue='pb_dismiss' )
   
   widget_control, control_base, set_uvalue=widget_Data, /realize

   xmanager, 'papco_slice_control', control_base
   
end





