pro papco_slice_listman, listhandle, arg1, $
                   create=create, $ 
                   is_valid=is_valid, $
                   header=header, $
                   reset=reset, $
                   destroy=destroy, $
                   dump=dump, $
                   add=add, delete=delete, $
                   tag_delete= tag_delete, $
                   tag_sort= tag_sort, $
                   tag_retrieve= tag_retrieve, $
                   retrieve= retrieve, $
                   store= store, $
                   get_type= get_type, $
                   get_header= get_header, $
                   set_header= set_header, $
                   next_retrieve=next_retrieve, $	
                   index=index, $
                   set_index= set_index

; listman:  general list manager for papco
; 
; I/O:
;    argument name  :  I/O  :  function
;    listhandle        I/O     contains the handle or reference to
;                              list.  For the create action, this is 
;                              set to the handle of the created list.
;                              Otherwise it is input.
;    arg1              I/O     function depends on action.

; Actions:
;    /create            creates new list.
;                       arg1= element type.
;    header=h           allows additional information to be placed in
;                       the list header.
;    /is_valid          check validity of list.  arg1=[0|1]
;    /reset             reset list to empty.
;                       if arg1 specified, then list type is reset to arg1
;    /destroy           destroy list.
;    /dump              dumps list contents. useful in debugging
;    /add               add arg1 to end of list
;    /delete            delete index arg1 from list
;    tag_delete='tag'   delete first element containing tag equal to arg1
;    tag_sort='tag'     sort according to this tag (must be sortable)
;    /retrieve          retrieve entire list --> arg1
;    /store             store arg1 --> entire list
;    tag_retrieve='tag' retrieve list elements with tag=arg1
;    /get_type          return a list element in arg1
;    /get_header        return user's header in arg1
;    /set_header        arg1 --> user header
;    /next_retrieve     retrieve next list element (see index in header)
;    index=index        gets the header index 
;    set_index=set_index  explicitly set index
;
;   History:
;      written Dec 1997   Jeremy Faden,
;                         jbf@space-theory.physics.uiowa.edu
;      Jan 1998         Jeremy Faden
;                       Generalized for use in papco routines.  This
;                       includes generalizing list elements type,  and
;                       using IDL handles to allow any number of lists
;                       to exist at once.

if keyword_set( create ) then begin
    if n_elements( header ) eq 0 then header=''
    list_header= { listArrayHandle:0L, $ ; points to list array
                   index:0L, $
                   header:header $ ; user-added header information
                 }
    list_array= [ arg1 ]        ; place holder
    listhandle= handle_create()
    listArrayHandle= handle_create()
    list_header.listArrayHandle= listArrayHandle
    handle_value, /set, listarrayhandle, list_array
    handle_value, /set, listhandle, list_header
    return
endif

if keyword_set( is_valid ) then begin
    if n_elements( listhandle ) eq 0 then begin
        arg1= 0
    endif else begin
        arg1= handle_info(listhandle) 
    endelse
    return
endif

if not handle_info(listhandle) then begin
    message, 'invalid list handle.', /cont
    return
endif

handle_value, listhandle, list_header
handle_value, list_header.listArrayHandle, list_array

if n_elements( set_index ) gt 0 then begin
    list_header.index= set_index
endif

if keyword_set( destroy ) then begin
    handle_free, listhandle
    handle_free, list_header.listArrayHandle
    r= temporary( listhandle )
    return
endif

list_empty= n_elements( list_array ) eq 1

if keyword_set( dump ) then begin
    n= n_elements( list_array )
    for i= 1, n-1 do begin
        help, list_array(i), /str
    endfor
    return
endif

if keyword_set( reset ) then begin    
    if n_elements( arg1 ) eq 0 then $ 
      list_array= list_array(0:0) $
    else $
      list_array= [ arg1 ]
endif

if keyword_set(add) then begin
    list_array= [list_array,arg1]
    list_header.index= n_elements( list_array ) -2
endif

if n_elements(delete) gt 0 then begin
    ikeep= make_array( n_elements( list_array(1:*)), value=1, /int ) 
    ikeep( delete )= 0
    r= where( ikeep )
    if r(0) ne -1 then begin
        list_array= list_array(0,r+1)
        list_header.index= ( max( delete ) + 1 ) - n_elements( delete )
    endif else begin
        list_array= list_array(0:0)
    endelse
endif

if n_elements(tag_delete) eq 1 then begin    
    if not list_empty then begin
        tag= tag_delete
        tagarr_str= 'list_array(1:*).'+tag
        exe_str= 'rindx=where('+tagarr_str+' ne arg1)'
        r= execute( exe_str )
        idel=  make_array( n_elements( list_array(1:*)), value=1, /int ) 
        if rindx(0) ne -1 then begin
            list_array= list_array( [0,rindx+1] )
            idel( rindx ) = 0
            delete= where( idel )
            if delete(0) ne -1 then $
              list_header.index= ( max( delete ) + 1 ) - n_elements( delete ) 
        endif else begin
            list_array= list_array( 0:0 )
            list_header.index= 0
        endelse
    endif
endif

if n_elements( tag_sort ) eq 1 then begin
    tag= tag_sort
    tagarr_str= 'list_array(1:*).'+tag
    exe_str= 'sindx=sort('+tagarr_str+')'
    r= execute( exe_str )
    list_array(1:*)= list_array( sindx+1 )
endif


if n_elements(tag_retrieve) eq 1 then begin    
    tag= tag_retrieve
    tagarr_str= 'list_array(1:*).'+tag
    exe_str= 'rindx=where('+tagarr_str+' eq arg1)'
    r= execute( exe_str )
    if rindx(0) ne -1 then begin
        arg1= list_array( rindx )
    endif else begin
        message, 'no matches found.', /cont
        if n_elements( arg1 ) gt 0 then r= temporary(arg1)
    endelse
end

if keyword_set( next_retrieve ) then begin
    if not list_empty then begin
        arg1= list_array( list_header.index+1 )
    endif else begin
        if n_elements(arg1) ne 0 then r= temporary(arg1)
    endelse
endif

if keyword_set( get_type ) then begin
    arg1= list_array(0)
    return
endif

if keyword_set( get_header ) then begin
    arg1= list_header.header
    return
endif

if keyword_set( set_header ) then begin
    list_header.header= arg1
endif

if keyword_set( retrieve ) then begin    
    if list_empty then begin
        if n_elements( arg1 ) eq 1 then r= temporary( arg1 )
    endif else begin
        arg1= list_array(1:*)
    endelse
endif

if keyword_set( store ) then begin    
    if n_elements( arg1 ) gt 0 then $
      list_array= [ list_array(0), arg1 ]
endif

list_header.index= list_header.index < (n_elements(list_array)-2) > 0
index= list_header.index

handle_value, /set, list_header.listArrayHandle, list_array
handle_value, /set, listhandle, list_header

return

end



