pro papco_slice_rw_list, sl_header, sl_data, sl_input_global, $
                         READ=READ, WRITE=WRITE

  common slice_sl_common, $
    fve_header, fve_data, fve_input_global, $
    fvi_header, fvi_data, fvi_input_global

  if n_elements( fve_header ) eq 0 then begin 
      message, 'Initializing list...', /cont
      init_fv, 960101, '00:00:00', sl_input
      common control_info, control_id, winidx, state, $
        species_store, control_ele, control_ion
      fve_input_global= sl_input
      fvi_input_global= sl_input      
      fve_input_global.species.ele= 1
      fve_input_global.species.ion= 0
      fve_input_global.control= control_ele
      fvi_input_global.species.ele= 0
      fvi_input_global.species.ion= 1
      fvi_input_global.control= control_ion
      
      sl_header= { sl_header_struct, $
                   start_time:double(0), $
                   end_time:1d31, $
                   reload_flag:1, $
                   n:51, m:51, $
                   handle:0L, $
                   species:0 $
                 }
      fve_header= sl_header
      fvi_header= sl_header
      
      fve_data= { sl_data_struct, $
                  time:double(0), $               
                  sl_input:fve_input_global, $
                  handle:-1L, $ ; identifies operation
                  species:-99, $ ; this one is a bogus place holder.
                  reload:0 }
      fvi_data= fve_data
      fvi_data.sl_input=fvi_input_global
  endif
  
  species =0
  
  if keyword_set(read) then begin
      if species eq 0 then begin ; select the context
          sl_header= fve_header
          sl_data= fve_data
          sl_input_global= fve_input_global
      endif else begin
          sl_header= fvi_header
          sl_data= fvi_data
          sl_input_global= fvi_input_global
      endelse
      
      return
  endif

  if keyword_set(write) then begin
      if species eq 0 then begin ; select the context
          fve_header= sl_header
          fve_data= sl_data
          fve_input_global= sl_input_global
      endif else begin
          fvi_header= sl_header
          fvi_data= sl_data
          fvi_input_global= sl_input_global
      endelse
      return
  endif
end
