;******************************************************************************
;*  NAME:        papco_add_mag_unilib
;*
;*  DESCRIPTION: adds magnetic field model coords to a given ephemeris
;*               file - keeps adding structures. 
;*
;*  INPUT:       cor_type  -  coordinate type of input ephemeris
;*               cor_sys   -  coordinate system of input ephemeris
;*               control   -  the module's control structure
;*
;*  OUTPUT:      
;*
;*  DATE:        July 2003
;*
;*  AUTHOR:       R. Friedel
;******************************************************************************
PRO papco_add_mag_unilib, control, cor_type, cor_sys, $
                          eph_struct_flname, new_struct_name, $
                          tai, pos, input_data, error

COMMON plot_composer, widgetdata
COMMON get_error, get_err_no, get_err_msg

;check if unilib is loaded in
IF NOT papco_unilib_init() THEN BEGIN
    error =get_err_no 
    return
ENDIF 

intmod = control.INTERNAL_MODEL
extmod = control.EXTERNAL_MODEL

new_struct_name='MODEL_'+varprt(intmod)+'_'+varprt(extmod)
new_struct=create_struct(name='UNILIB_3', 'L',0.0,'LSTAR', -99.0, $
                         'MLT',0.0,'MLAT',0.0, $
                         'B_GSM', fltarr(4), 'B_EQU', 0.0)

restore, file = eph_struct_flname 
need_tags = tag_names(eph_struct)
tags=tag_names(input_data(0))

;now, see if we have any missing tags!
n = 0 & todo_tags = ''
FOR i = 0, n_elements(need_tags)-1 DO BEGIN 
    idx = where(need_tags(i) EQ tags, c)
    IF c EQ 0 THEN BEGIN
        IF (n EQ 0) THEN todo_tags = need_tags(i) $
        ELSE todo_tags = [todo_tags, need_tags(i)]
        n = n+1
        m_new_struct = 1
    ENDIF 
ENDFOR

IF control.orig EQ 1 THEN begin
    ;now see if we have to add the currently selected mag field too.
    idx = where(new_struct_name EQ tags, c)
    IF c EQ 0 THEN BEGIN
        idx = where(new_struct_name EQ todo_tags, c)
        IF c EQ 0 THEN BEGIN 
            IF (n EQ 0) THEN todo_tags = new_struct_name $
            ELSE todo_tags = [todo_tags, new_struct_name]
            n = n+1
        ENDIF 
        m_new_struct = 1
    ENDIF ELSE BEGIN
        ;if L* is selected, check if for current choice of model it needs to
        ;be done.
        IF control.l_calc EQ 1 THEN BEGIN
            idx2 = where(new_struct_name EQ tags, c)
            idx = where(input_data.(idx2(0)).LSTAR NE -99, c2)
            IF c2 EQ 0 THEN BEGIN 
                IF (n EQ 0) THEN todo_tags = new_struct_name $
                ELSE todo_tags = [todo_tags, new_struct_name]
                n = n+1
            ENDIF 
            m_new_struct = 0
        ENDIF     
    ENDELSE 
ENDIF

IF n EQ 0 THEN BEGIN
    message, 'No Mag Coords to do', /cont
    error = 2   ;no new structures added to input_data
    return      ;no mag field coords to do
ENDIF 

FOR i = 0, n-1 DO BEGIN ;loop through all mag coords todo
    
    ;get intmod,extmod from model name tags
    intmod = fix(strmid(todo_tags(i), 6, 1))
    extmod = fix(strmid(todo_tags(i), 8, 1))

    IF m_new_struct THEN BEGIN 
        ;add new structure tag to array
        dummy2=create_struct(input_data(0),todo_tags(i),new_struct)
        dummy3=replicate(dummy2,n_elements(input_data)) 
        ;fill new array with copies of existing array
        struct_assign, input_data, dummy3, /NOZERO
        input_data=temporary(dummy3)

    ENDIF

    ;get the index of the new mag coords tag
    tags=tag_names(input_data(0)) 
    index=where(tags eq todo_tags(i))
    new_idx=index(0)  
    ndat =  n_elements(input_data)

    ;get mag coords (from UNILIB) 
    ;tai and pos is passed in, so is cor_type and cor_sys

    IF control.l_calc EQ 1 THEN BEGIN
        lstar = 1 
        message,' finding L, L*, MLT, MLAT, B_GSM, B_EQU for ' + $
          todo_tags(i), /cont
    ENDIF ELSE BEGIN
        lstar = 0
        message,' finding L, MLT, MLAT, B_GSM, B_EQU for '+todo_tags(i), /cont
    ENDELSE 

    get_mag_unilib, tai, pos, cor_type, cor_sys, $
                    bvec, bequ, Lval, mlt, ilat, error, $
                    INTMOD=INTMOD, EXTMOD = EXTMOD, $
                    LSTAR = lstar, VERBOSE = VERBOSE
      
    input_data.(new_idx).L = Lval
    IF control.l_calc EQ 1 THEN input_data.(new_idx).Lstar = lstar
    input_data.(new_idx).mlt = mlt 
    input_data.(new_idx).mlat = ilat
    input_data.(new_idx).b_gsm = bvec
    input_data.(new_idx).b_equ = bequ

ENDFOR

error = 0 ;no errors to report

END
