;initialize UNILIB library
;
FUNCTION papco_unilib_init, VERBOSE = VERBOSE

COMMON get_error, get_err_no, get_err_msg
COMMON unilib, unlib_ok

if keyword_set(VERBOSE) then verbose=1 else verbose=0
if keyword_set(unlib_ok) THEN unlib_ok = unlib_ok ELSE unlib_ok = 0

IF unlib_ok THEN return, 1

;setup unilib shareable object location. This test for current
;operating system and IDL version and returns error if not available
lib = papco_get_unilib_exe()
IF lib EQ '' THEN BEGIN
    get_err_msg = 'Unilib library not compiled'
    message, get_err_msg, /info
    get_err_no = 1 & unlib_ok = 0 & return, 0
ENDIF

;set lib location as environmental variable
papco_setenv, 'PAPCO_UNILIB='+lib

;    Define the different structures used by unilib. This correctly
;    sets the variable types expected by unilib.
;    Chose unique names for the structures to avoid naming conflicts -
;    all are prefixed with papco_

dummy = {papco_zxyz, x:      0.0d0, y:         0.0d0, z:     0.0d0}
dummy = {papco_zgeo, radius: 0.0d0, colat:     0.0d0, elong: 0.0d0}       
dummy = {papco_zvec, dnrm:   0.0d0, rho:       0.0d0, theta: 0.0d0,     $
                     phi:    0.0d0}
dummy = {papco_zpnt, coord: {papco_zgeo}, b:  {papco_zvec}, rcurv: 0.0d0}
dummy = {papco_zseg, beg:   {papco_zpnt}, arcl:      0.0d0, csalp: 0.0d0,     $
                     dtbnd:  0.0d0, rkstp: dblarr(3)}
dummy = {papco_zlbl, label:    ' ', linv:         0b, lbmp:     0b,     $
                     lkauf:     0b, llmi:         0b, lalp0:    0b,     $
                     lphi:      0b, ltim:         0b, finv:  0.0d0,     $
                     fbmp:   0.0d0, fkauf:     0.0d0, flmi:  0.0d0,     $
                     falp0:  0.0d0, fphi:      0.0d0, ftim:  0.0d0}
dummy = {papco_zdat, iyear:  1950L, imonth:       1L, iday:     1L,     $
                     ihour:     0L, imin:         0L, secs:  0.0d0,     $
                     amjd:   0.0d0}
;    Call UT990 to initialize the UNILIB libray
;    MOD by RF to UT990: set kinit to 533 to disable magnetopause
;    checking
;
;    Note that the argument version is set to the correct type
;    before the use of the function CALL_EXTERNAL.

version = 0L
IF verbose THEN kunit = 6L ELSE kunit = 0L
kinit = 533L
entry = 'uxidl_'
status  = CALL_EXTERNAL( lib, entry, 'UT990', kunit, kinit, version)
IF version LT 0 THEN BEGIN
    message, 'Unable to initialize the Unirad Library', /info
    unlib_ok = 0 & return, 0
ENDIF

print, ''
message, 'Unilib Library v'+ STRCOMPRESS( STRING( version*0.01,    $
               format= '(f10.2)'), /remove_all), /info
print, ''
unlib_ok = 1

return, 1

END
