;+
; NAME:
;	DAYCNVRT
;
; PURPOSE:
;       This is a general purpose IDL procedure to convert 
;       from the DAY MONTH YEAR to DAY_OF_YEAR.
;       This is used heavily in the readout routines to calculate
;	the correct EPOCH time from normal UT inputs.
;	
; CATEGORY:
;       Time conversion
;
; CALLING SEQUENCE:
;
;       Doy = DAYCNVRT(iyear,iday,cmonth0)
;
; INPUTS:               Iyear	= Integer year value
;			Iday	= Integer day of month value
;			Cmonth0	= At least 3 Character of the month
;                                 or INT 1-12
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:      	DOY  = Integer day of year value
;
; MODIFICATION HISTORY:;
; written 08.01.90	S. Mazuk
; revised 1 dec 92      M. Fraenz
;         2/1/94  : INT cmonth0 MF
;
;-
;
	FUNCTION Daycnvrt, Iyear, Iday, Cmonth0
;
;
; First of all we need to determine the month number from the character input
;
	Moarray= STRARR(13)
;
        mosize=size(cmonth0)
        IF mosize(1) EQ 7 THEN BEGIN
 	 Cmonth = Strupcase(Cmonth0)
         Cmonth=STRMID(cmonth,0,3)
;
	 CASE Cmonth OF
         'JAN':Imonth = 1
         'FEB':Imonth = 2
         'MAR':Imonth = 3
         'APR':Imonth = 4
         'MAY':Imonth = 5
         'JUN':Imonth = 6
         'JUL':Imonth = 7
         'AUG':Imonth = 8
         'SEP':Imonth = 9
         'OCT':Imonth = 10
         'NOV':Imonth = 11
         'DEC':Imonth = 12
         ENDCASE
        ENDIF ELSE Imonth=cmonth0
;
;
        dayarray=[0,31,28,31,30,31,30,31,31,30,31,30,31]
	if (FIX(iyear/4)*4 eq iyear ) then dayarray(2)=29
;
; Now calculate the DOY. Recall that the IDAY value counts from 1 as a natural
;	number. DAY_OF_YEAR is a natural number count on the output. 
;
	DOY = fix(total(Dayarray(indgen(imonth))) + Iday) 
        IF iday GT dayarray(imonth) THEN BEGIN
         message,'wrong date',/INF
         DOY=-1
        ENDIF
;
	return,DOY
	end
;
