;******************************************************************************
;* FUNCTION:     
;*      FUNCTION  ae_ascii_panel, aPlotInfo, GROUP=group, ACTION=ACTION
;* 
;* DESCRIPTION:  
;*	Open an editor for a panelplot.
;*	Its window is constructed using the methods defined in the file
;*	$papco_PATH/papco_panel.pro
;*	When the user presses the 'Done'- or the 'Cancel'-Button, the values 
;*	changed by the event-methods of papco_panel.pro are returned.
;*	The returned value is a structure containing those values and a flag,
;*	'canceled', which the caller may read out to check, whether the 
;*	window was closed using the 'Cancel' or the 'Done'-Button.
;*
;* INPUTS:       
;*	aPlotInfo	a structure of the papco_PLOTINFO-type
;*			this structure is edited in the window.
;*     
;* KEYWORDS:
;* 	GROUP		a WIDGET_BASE
;*			when specified, this is used as GROUP_LEADER
;*	ACTION		a string
;*			when specified, the 'Done'-Button is labeled with it
;*		        if not specified, the 'Done'-Button is labeled 'Done'
;*
;* OUTPUT:	 
;*      a default-structure of type papco_PANEL_EDITOR_RETURN. Though this
;*	type is nowhere defined, I like to think of it as virtually existing
;*	data-type. 
;*	All the functions in $papco_PATH/papco.pro that edit plots or add new
;*	ones, expect the opened editor-windows to return a structure containing
;*	at last some fields. Those fields might make up a structure, but as no
;*	program defines the structure-type papco_PANEL_EDITOR_RETURN, this 
;*	poor structure is not alive but only virtual.
;*	The return-values of plot-editors have to expand this structure - I 
;*	like to think, that they inherit from that structure - and contain at
;*	least those fields:
;*   		{$
;*			canceled:1, $
;*	    		panelHeight:1, $
;*	    		channel:0, $
;*	    		typeVector:[0,0,0,0], $ 
;*	    		manualYScaling:0 $
;*	    		yScaleMin:LONG(1), $
;*	    		yScaleMax:LONG(1), $
;*	    		panelKind:'some string'}
;*
;*      Additionally, some Panel-editors may return these fields in
;*      structure:
;*               {$
;*		        color:1, $
;*			plotStyle:1}
;*			
;*      For an enhanced description read $papco_PATH/papco_variables.text
;*
;* CALLING SEQUENCE:
;*	aPlotInfoStruct=papco_getPlotInfoStruct()
;*
;* MODIFICATION HISTORY:       
;*     written october 1995, Reiner Friedel
;*     modified Feb 1998 to read ASCII files by Doug Rowland
;******************************************************************************
FUNCTION  ae_ascii_panel, aPlotInfo, GROUP=group, ACTION=ACTION
   
COMMON AE_ASCII_PANEL_DATA, widgetData

; if GROUP is not specified, the group-leader will be the desktop
IF NOT KEYWORD_SET(GROUP) THEN GROUP=0

; set the label for the action-button
IF NOT KEYWORD_SET(ACTION) THEN ACTION='Done'

; the routines used by papco_panel.pro define tags for a structure. Those
; tags will be stored in the structure 'additionalWData'. When you realize the
; window, you have to add your own window-specific data to that structure 
; and afterwards assign it to widgetData.
 additionalWData={canceled:1}

;--- create the base-window ---------------------------------------------------
panel_base=papco_WIDGET_BASE(title=aPlotInfo.panelKind, $
                                column=1, GROUP_LEADER=group, /MODAL)

;--- the first part of the window will consist in the widgets -----------------
;    that control the height of that plot
 widgets=papco_panel_AddHeightWidgets(panel_base, aPlotInfo)
 additionalWData=create_struct(widgets, additionalWData)

;
;---  <<<<<<<<<<  insert your widgets below here!  >>>>>>>>>
;

names=['AE index', 'AL index', 'AU index', 'AO index']
mpb_prod = CW_BGROUP(panel_base, names, /FRAME, ROW=1, /EXCLUSIVE, $
                     UVALUE = 'mpb_prod', SET_VALUE = aplotinfo.typevector(0))

;
;---  <<<<<<<<<<  insert your widgets above here!  >>>>>>>>>
;   
  
;--- add the widgets for choosing the plot-style ------------------------------
widgets=papco_panel_add_PlotStyleButtons(panel_base, aPlotInfo, 0)
additionalWData=create_struct(widgets, additionalWData)
   
;--- now, add the widgets for choosing the y-axis-ranges ----------------------
widgets=papco_PANEL_AddYScale_Widgets(panel_base, aPlotInfo)
additionalWData=create_struct(widgets, additionalWData)
   
;--- finally, the Actionbuttons (help, cancel, done) are added to the ---------
;    editor window.
widgets=papco_panel_AddActionButtons(panel_base, Action, aPlotInfo, /CONFIG)
additionalWData=create_struct(widgets, additionalWData)

;--- now, create the structure that keeps the panel-window data. You
;    always need to specify the help-file, and your structure must
;    always contain the 'additionalWData'.
thisWidgetsData={helpfile:'ae_ascii_panel.help',$
                 typeVector:aPlotInfo.typeVector}
widgetData=papco_PANEL_CreateWidgetData(thisWidgetsData, additionalWData)

;--- realize the window
papco_Panel_Realize, panel_base, widgetData

; As this is a function that will return all changes made by the
; user, the xmanager has to be called with the keyword MODAL. If we
; wouldn't specify /MODAL, no changes would be reportet but the 
; data contained in aPlotInfo would be returned.
papco_xmanager, 'ae_ascii_panel', panel_base

; the returned data consists of the standard-data inherited from
; papco_PANEL.PRO and your new data - e.g. the typeVector-tag.
returnData={typeVector:widgetData.typeVector}
additionalRData=papco_panel_ReturnData(widgetData)

return, create_struct(ReturnData, additionalRData)

END

;******************************************************************************
;* ;* PROCEDURE:     
;*      PRO papco_panel_template_event, event
;* 
;* DESCRIPTION:  
;*	This processes events from the XMANAGER.
;*	As this example does not extend the basic functionality of plot-
;*	editors, it directly calls the default-handler, papco_PANEL_Event
;*
;* INPUTS:       
;*	event		an XManager event
;*			
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	called by XMANAGER
;*
;* MODIFICATION HISTORY:       
;*     written october 1995, Reiner Friedel
;*
;******************************************************************************
PRO ae_ascii_panel_event, event
   
COMMON AE_ASCII_PANEL_DATA, widgetData
   
WIDGET_CONTROL,GET_UVALUE=uval, event.id

CASE uval OF

   'mpb_prod' : widgetData.typeVector(0)=event.value

   ELSE: widgetData=papco_panel_Event(event, widgetData)

ENDCASE

END
