;******************************************************************************
;* file papcoadd_ae_ascii
;*      papcoadd_ae_ascii
;* end
;*
;* this files contains all the collected routines which have to be added in
;* for ae_ascii 
;*
;* papco is written such that if the files starting with "papcoadd" exist
;* in the papco_MODULES directory
;* then the routines contained therin are utilised to add that plot type
;* into the papco package. This ensures easy extendability of papco; also makes
;* papco "configurable" by adding or leaving out specific Plot types.
;******************************************************************************

;******************************************************************************

;* PROCEDURE:     
;*      PRO addplottype_ae_ascii,plottypes_base,buttonGeometry,pb_plottype
;* 
;* DESCRIPTION:  
;*	This procedure adds a button for this plottype to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*	papckage, so that they can be automatically called when needed.
;*
;* INPUTS:       
;*	plottypes_base	the widget ID of the parent widget to contain the
;*			plottype buttons.
;*      buttonGeometry  size of the button
;*
;* OUTPUTS: 
;*   	pb_plottype	the widget ID of the button created here.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addplottype_ae_ascii,plottypes_base,pb_plottype
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro addplottype_ae_ascii,plottypes_base,buttonGeometry,pb_plottype

  pb_plottype = WIDGET_BUTTON(plottypes_base,  $
                                 VALUE=strcenter('AE_ASCII',10), $
                                 UVALUE='pb_ae_ascii', $
                                 _extra=buttonGeometry)

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO plottable_ae_ascii, plottable
;*
;* DESCRIPTION:  
;*	Sets a variable to indicate plottable without orbit.
;*
;* INPUTS:       
;*	none
;*
;* OUTPUTS: 
;*   	plottable	a boolean 0 if plottable only by CRRES orbit
;*                                1 if plottable by time also.
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	plottable_ae_ascii, plottable
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro plottable_ae_ascii, plottable

plottable=1

END

;******************************************************************************
PRO canget_ae_ascii, canget

canget=  1      ; 1 -> plot routine can return just data to file
                ; 0 -> feature disabled

END


;******************************************************************************

;* PROCEDURE:     
;*      PRO descriptor_ae_ascii, plotInfo, descriptStr
;*
;* DESCRIPTION:  
;*	Constructs the string used to label plots in the panel window
;*
;* INPUTS:       
;*	plotInfo        structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	descriptStr	a string containing the label
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	descriptor_ae_ascii, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro descriptor_ae_ascii, plotInfo, descriptStr
  
   typeNames=['AE index', $
              'AL index', $
              'AU index', $
	      'AO index']  
  
   descriptStr=descriptStr+typeNames(plotInfo.typeVector(0))

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO addpanel_ae_ascii,event
;*
;* DESCRIPTION:  
;*	Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      using an instance of the papco_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled.
;*
;* INPUTS:       
;*	event		event value of papco main window
;*
;* OUTPUTS: 
;*   	none
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	addpanel_ae_ascii
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;******************************************************************************
pro addpanel_ae_ascii,event

  panelKind='ae_ascii'
  defaults=papco_getPlotInfoStruct()
  defaults.typeVector=[0,0,0,0]
  defaults.plotstyle=10 
  papco_Add_Plot, 'ae_ascii_panel', panelKind, initialPlotInfo=defaults

END

;******************************************************************************
;* PROCEDURE:     
;*      PRO draw_ae_ascii, panelVector, currPlotInfo, orbitNr, $
;*                                     get_data_call, slice_type, IsRead
;* DESCRIPTION:  
;*	This procedure performs the actual data read call and the plot call
;*      for this plottype  
;*
;* INPUTS:       
;*	panelVector	position of the plot (see papco_conventions.text, 6)
;*	currPlotInfo	structure containing all data for this plot.
;*                      (structure type: papco_PLOTINFO, 
;*                                             see papco_variables.text) 
;*
;* OUTPUTS: 
;*   	get_data_call	a string containing the data call. Used by other
;*                      routines that need to know how to get the data
;*                      in a panel, e.g. draw spectra, distribution functions
;*      IsRead		a boolean which is set when the the data is read the
;*                      first time. Useful if a given data read puts data
;*                      into commons which can be plotted in many ways.
;*                      When set, data does not have to be read again.
;*      slice_Type 	an integer which sets the type of slicing
;*                      plot to do
;*
;* KEYWORDS:
;* 	none
;* 
;* CALLING SEQUENCE:
;*	draw_ae_ascii, panelVector, currPlotInfo, $
;*                          get_data_call, slice_type, IsRead
;*
;* MODIFICATION HISTORY:       
;*     written November 1995, Reiner Friedel
;*    modified December 1995, Reiner Friedel, to support overplot, color
;*                                            and line styles 
;******************************************************************************
pro draw_ae_ascii, panelVector, currPlotInfo, orbitNr, $
                   get_data_call, Slice_type, IsRead, $
                   OUTPUT=OUTPUT

common extra, extra_PlotInfo

get_data_call ='' 
slice_Type=1+8+16+32
IsRead=0 
   
IF NOT IsRead THEN BEGIN
    r_ae
    IF papco_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel) THEN IsRead=1 $
    ELSE IsRead=0
ENDIF

IF IsRead THEN p_ae, panelVector, currPlotInfo, OUTPUT=OUTPUT, $
  _EXTRA=extra_PlotInfo

END
