;******************************************************************************
;* PROCEDURE:     
;*      p_ae, panel, plotype, OUTPUT=OUTPUT, $
;*           OVERPLOT=OVERPLOT,$
;*           PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           SUBTABLE=SUBTABLE, _EXTRA=extra_par
;* 
;* MODIFICATION HISTORY:       
;*     written December 2003, Reiner Friedel
;******************************************************************************
pro p_ae, panel, plotinfo, OUTPUT=OUTPUT, $
          OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
          SUBTABLE=SUBTABLE, _EXTRA=extra_par

;
;inputs  panel = panel vector
;        type  = select which component: 0 -  AE
;                                        1 -  AL
;                                        2 -  AU
;                                        3 -  AO

COMMON ae_data, input_header, input_data
COMMON mjdt, mjdt_start, mjdt_end
COMMON coordinateSystems, plotted_x, plotted_y
COMMON yscale, yscl			;man/auto yscaling
COMMON shift_label,down

; restrict data to actual time range requested - this makes for faster zooming
; rememember input data is in TAI. For plotting, always start at zero
; to get maximum resolution (plot works in float only, large values
; get rounded! 
tai_1=utc2tai({mjd:mjdt_start.mjd, time:mjdt_start.t*1000})
tai_2=utc2tai({mjd:mjdt_end.mjd, time:mjdt_end.t*1000})
index=where((input_data.tai ge tai_1) AND (input_data.tai le tai_2),c)
IF c NE 0 THEN data = input_data(index) ELSE GOTO, noplot

xut1=0  &  xut2=tai_2-tai_1  & time=data.tai-tai_1
ndat = n_elements(data)  

type = plotinfo.typevector(0)

ptit='AE indices'
uytitle = 'nT'
   
nodata = -99
panelset, panel

CASE type OF
    0:BEGIN 
        yray=data.ae & utitle='AE_index'
        idx = where(yray GT 5000, c)
        IF c NE 0 THEN yray(idx) = nodata
    END 
    1:BEGIN 
        yray=data.al & utitle='AL index'
    END  
    2:BEGIN 
        yray=data.au & utitle='AU index'
    END  
    3:begin
         yray=ao
         utitle='AO index'
       end
    else:STOP
ENDCASE  
  

IF (yscl(panel(0),0) eq 1) THEN BEGIN
    yst=yscl(panel(0),1)  &  yen=yscl(panel(0),2)
ENDIF ELSE BEGIN
    papco_ylim, time, yray, yst, yen, LOG = yscl(panel(0),3), BAD_DATA = nodata
    yscl(panel(0),1)=yst  &  yscl(panel(0),2)=yen
ENDELSE 

; use auto y-labeling routine to get "good" y-lables
papco_y_label, yst, yen    

; set up extra plot keywords, common ones first
extra_plotPar={yrange:[yst, yen], xrange:[xut1, xut2], $
               xtickformat:'noticks'}
  
; add keyword structure set here with the one passed in
extra_plotPar=create_struct(extra_plotPar, extra_par)
   
; use papco rotuine to draw time axis. This checks for bottom plot
; and uses the user's  xtickformat if it is something other than 'noticks'.
down=0
papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar     

; now do the actual data plot
papco_gap_plot, time, yray, nodata, _extra=extra_plotPar, xstyle=5, ystyle=5

; store the coordinate information into common block
plotted_x = !x  &  plotted_y = !y

; plot y-axis label at left of plot. Use scalable routine!  
IF NOT keyword_set(overplot) THEN left_side_label,panel, uytitle, /rot90   

; plot info right of the panel. Multiple pnale labels are handled.
papco_rs_lbl, panel, utitle, /LINE, _extra=extra_Par

if KEYWORD_SET(OUTPUT) THEN BEGIN
    message,'Writing plot data to file',/cont
    description='ae data output'
    time_label='TAI'
    trange=[xut1,xut2]
    y_label=uytitle
    rs_label=utitle
    papco_write_data, time+tai_1, yray, $
                      DESCRIPTION=description, TIME_LABEL=time_label, $
                      Y_LABEL=y_label, TRANGE=trange, $
                      RS_LABEL=RS_LABEL, FORMAT=format
ENDIF

return

;jump to here if no data to plot 
noplot: 
  message,'No data to plot', /cont
  plotted_x = !x  &  plotted_y = !y


END 
