pro p_ae_ascii, panel, type, $
           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
           SUBTABLE=SUBTABLE, $
           _EXTRA=extra_par

;
;inputs  panel = panel vector
;        type  = select which component: 0 -  AE
;                                        1 -  AL
;                                        2 -  AU
;                                        3 -  AO

   common aeascii, ae,au,al,ao,aetimemjd
   common mjdt, mjdt_start, mjdt_end
   common coordinateSystems, plotted_x, plotted_y
   common yscale, yscl			;man/auto yscaling
   common shift_label,down

   ptit='AE indices'
   
   FILLVAL = 99999 
   panelset,panel

   case type of
     0:begin
         yray=ae
         ctit2='AE_index'
       end
     1:begin
         yray=al
         ctit2='AL index'
       end
     2:begin
         yray=au
         ctit2='AU index'
       end
     3:begin
         yray=ao
         ctit2='AO index'
       end
     else:STOP
    endcase
  
  time = (aetimemjd.mjd - mjdt_start.mjd)*86400L + aetimemjd.t
   
  xut1 = mjdt_start.t
  xut2=long(mjdt_end.mjd-mjdt_start.mjd)*86400l+mjdt_end.t
  index = where((time ge xut1) and (time le xut2) and (yray ne FILLVAL),count)
  
  if (count ge 2) then begin
    yen = max(yray(index),min=yst)
    ydist = abs(yen - yst)
    yst = yst - .1*ydist
    yen = yen + .1*ydist
  endif else begin
     yst = -1
     yen =  1 
  endelse 
   
  cytit='nT'
; select only the time interval to be plotted. This is not needed, but does
; speed up plotting images
 ; index=where((time ge xut1) and (time le xut2) and (yray ne FILLVAL),count)
  if count ge 2 then begin
    time=time(index)  &  yray=yray(index)
  end
; yscl of common block yscale is an array of dimensions (*,3) and contains info
; on the yscaling to be used. The first dimension identifies the panel, and the
; next dimension has three entries:  
;         yscl(*,0)  is  0 for "use automatic scaling", 1 for "use manual"
;         yscl(*,1)  is then ymin (or zmin)
;         yscl(*,2)  is then ymax (or zmax)
; when scaling is set to automatic, the automatic y limits are loaded in.
  if (yscl(panel(0),0) eq 1) then begin
    yst=yscl(panel(0),1)  &   yen=yscl(panel(0),2)
  endif else begin
    yscl(panel(0),1)=yst  &   yscl(panel(0),2)=yen
  endelse
    
; use auto y-labeling routine to get "good" y-lables
  papco_y_label, yst, yen    

; set up extra plot keywords, common ones first
  extra_plotPar={yrange:[yst, yen], xrange:[xut1, xut2], $
                 ytitle:cytit, xtickformat:'noticks'}

; check if the passed-in structure extra_par was set. If not, create
; it and set color to default black; which for the color table used by
; papco is 1. If extra_par was set, see if the tag color exists. If it
; does, leave it unchanged, if not, add it and set color to default
; black.
  if n_elements(extra_par) EQ 0 then extra_par={color:1} else begin
    names=tag_names(extra_par)
    res=where(names eq 'COLOR',count)
    if count eq 0 then extra_par=create_struct({color:1}, extra_par)
  endelse     
  
; add keyword structure set here with the one passed in
   extra_plotPar=create_struct(extra_plotPar, extra_par)
   
; use papco rotuine to draw time axis. This checks for bottom plot
; and uses the user's  xtickformat if it is something other than 'noticks'.
  down=0
  papco_draw_time_axis, panel, OVERPLOT=OVERPLOT, _extra=extra_plotPar     

; now do the actual data plot
  plot,time,yray, _extra=extra_plotPar, xstyle=5, ystyle=5

; store the coordinate information into common block
  plotted_x = !x  &  plotted_y = !y

; plot extra x-axis labels (eg. ephemeris) and a x-axis label if required.
; plot in color=1. Example here adds an axis with date information.
; the routine x_side_label puts x-axis label to the right of the axis.
; Use the keyword XTICKLEN if your x-axis ticklengths are not the
; default 0.015


; plot info right of the panel. If you want overplots to have there own label
; you need to add position control for this label using the keyword
; PLOTS_ATTHISPOSITION
  if not keyword_set(overplot) then right_side_label,panel,ctit2

end 
