;******************************************************************************
;* PROCEDURE:     
;*      PRO salammbo_commons
;* 
;* DESCRIPTION:  
;*      simply sets up a couple of often used arrays in common blocks.
;*
;* INPUTS:       
;*      none
;*                  
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      salammbo_commons
;******************************************************************************
PRO aero_heo_commons
  
COMMON aero_heo, aero_heo_sats, aero_heo_products, aero_heo_ech, aero_heo_G, $
                 aero_heo_ecal, eph_select_names, eph_select_frmts, $
                 aero_heo_control

aero_heo_sats = ['HEO_1', 'HEO_3']

aero_heo_products = ['ELEC1', 'ELEC2', 'CELEC3', 'CELEC4', 'CELEC5', 'ELEC6', $
'CPROT1', 'PROT2', 'PROT3', 'PROT4', 'PROT5', 'PROT6', 'PROT7', $
'DOSE1', 'DOSE2', 'DOSE3', 'DOSE4', 'DDOSE1', 'DDOSE2', 'DDOSE3', 'DDOSE4']

aero_heo_ech = [0.13, 0.23, 0.45, 0.63, 1.5, 3.0, $
                0.08, 0.16, 0.32, 5, 8.5, 16, 27]

aero_heo_G = [5.4e-3, 5.4e-3, 5.4e-3, 0.4615, 0.45,  0.45, $
              0.45, 5.4e-3, 5.4e-3, 5.4e-3, 0.4615,  0.45, 0.45, 0.45]

;calibration factors for the fluxes. Initially obtained from best fits
;to Salammbo output - this in fact cross calibrates with GPS/GEO for
;                     electron channels only
aero_heo_ecal = [2.0, 4.0, 6.0, 0.5, 2.0, 2.0]

;enter varibales for filtering the data
eph_select_names = ['L_VAL', 'MLT', 'MLAT']
eph_select_frmts = ['(f4.1)', '(f4.1)', '(f5.1)']

;finally, set up a structure for all the variables needed by the
;lanl geo eph  module to control the behaviour of the module. This
;replaces the old use of "ioptions, options and soptions" tags of the
;plotinfo structure by a user defined structure which contains mre
;descriptive and verbose tags for easier use.

aero_heo_control = { $
  sat_id:0,    sat_id_info: 'Satellite choice, index into aero_heo_sats', $
  product:0l, product_info:'Product to plot, index into aero_heo_products', $
  cal:0,          cal_info:'0: Counts/sec, 1: Int. Flux, 2: Diff. Flux', $
  graph:0,      graph_info:'0: Line, 1: Spec, 2:L-v. time', $
  equ:0,          equ_info:'0: on Magnetic equator, 1: at satellite orbit', $
  orig:0,        orig_info:'original (0) or model (1) coords', $
  filter:0,    filter_info:'Index into select_names filter varibale to use', $
  smooth:0,    smooth_info:'0: none, 1: vertically, 2: horizontally, 3: both'}

;now get the papco_panel tags for the papco_panel_Add_MagMod_Widgets
;tags, add them to lanl_geo_eph_control
aero_heo_control = CREATE_STRUCT(aero_heo_control, $
                       papco_panel_Add_MagMod_Widgets(/STRUCT_ONLY))
  
;now get the papco panel tags for the various select variables.
FOR i = 0, n_elements(eph_select_names)-1 DO $
  aero_heo_control = CREATE_STRUCT(aero_heo_control, $
        papco_panel_AddVar_Sel_Widgets(aBase, eph_select_names(i), $
                                       select, st, en, v1, v2, vr, $
                                       eph_select_frmts(i), /STRUCT_ONLY))

;finally name the control structure. This is required for load/save operations!
aero_heo_control = CREATE_STRUCT(name = 'aero_heo_controlb', aero_heo_control)

END
