;******************************************************************************
;* PROCEDURE:     
;*      PRO cassini_caps_definition,ELS=ELS,IBS=IBS,IMS=IMS
;* 
;* DESCRIPTION:  
;*      update the energy for one detector ELS or IMS or IBS
;* 
;* INPUTS:       
;*      none
;* 
;* KEYWORDS:
;*      only the fields corresponding to the set keyword are updated
;*
;* CALLING SEQUENCE:
;*      cassini_caps_definition,/ELS
;*
;* MODIFICATION HISTORY:       
;*     Written April 2001,  S. Bourdarie (ONERA/DESP)
;******************************************************************************
   pro cassini_caps_definition,ELS=ELS,IBS=IBS,IMS=IMS

   COMMON cassini_caps_line_energy, energy

   if keyword_set(ELS) then begin
     energy = [26040.00,22227.00,18991.00,16256.00,13876.00,11867.00,$
               10143.00, 8674.00, 7415.00, 6336.00, 5416.00, 4630.00,$
                3956.00, 3383.00, 2890.00, 2471.00, 2112.00, 1805.00,$
                1544.00, 1319.00, 1128.00,  964.10,  824.00,  704.30,$
                 601.80,  514.80,  439.40,  375.90,  321.50,  274.80,$
                 235.00,  200.90,  171.70,  146.90,  125.10,  107.40,$
                  91.76,   78.18,   67.15,   57.45,   49.00,   41.81,$
                  35.84,   30.49,   26.34,   22.21,   19.26,   16.33,$
                  13.98,   11.64,    9.89,    8.72,    7.56,    6.39,$
                   5.23,    4.64,    4.06,    3.48,    2.90,    2.32,$
                   1.74,    1.16,    0.58]
   endif 
   if keyword_set(IMS) then begin
     energy = [46343.75,38964.97,32771.22,27557.27,23166.22,19488.14,$
               16387.24,13772.98,11588.77, 9744.07, 8193.62, 6892.15,$
                5794.38, 4866.38, 4096.81, 3440.41, 2897.19, 2433.19,$
                2048.40, 1720.21, 1448.60, 1217.79, 1023.90,  861.23,$
                 724.13,  608.75,  512.10,  430.61,  361.92,  304.52,$
                 256.05,  215.31,  181.11,  152.26,  127.87,  107.65,$
                  90.40,   76.13,   63.98,   53.83,   45.20,   38.06,$
                  32.00,   26.90,   22.63,   19.03,   16.00,   13.46,$
                  11.31,    9.51,    8.00,    6.73,    5.66,    4.76,$
                   4.00,    3.36,    2.83,    2.37,    2.00,    1.68,$
                   1.41,    1.19,    1.00]
   endif 
   if keyword_set(IBS) then begin
       energy = [9530.16,9409.52,9168.25,9059.02,8939.05,8818.41,8709.84,$
                 8601.27,8492.70,8384.13,8166.98,8070.48,7961.90,7865.40,$
                 7768.89,7672.38,7575.87,7382.86,7286.35,7189.84,7105.40,$
                 7008.89,6924.44,6840.00,6743.49,6574.60,6490.16,6417.78,$
                 6333.33,6248.89,6176.51,6092.06,6019.68,5862.86,5790.48,$
                 5718.10,5645.72,5573.33,5500.95,5428.57,5368.25,5223.49,$
                 5163.17,5102.86,5106.48,4970.16,4909.84,4837.46,4777.14,$
                 4656.51,4596.19,4547.94,4487.62,4427.30,4379.05,4318.73,$
                 4210.16,4149.84,4101.59,4053.33,4005.08,3944.76,3896.51,$
                 3848.25,3751.75,3703.49,3655.24,3606.98,3570.79,3522.54,$
                 3474.28,3426.03,3341.59,3305.40,3257.14,3220.95,3184.76,$
                 3136.51,3100.32,3064.13,2979.68,2943.49,2907.30,2871.11,$
                 2835.95,2798.73,2762.54,2726.35,2653.97,2629.84,2593.65,$
                 2557.46,2521.27,2497.14,2460.95,2400.63,2364.44,2340.32,$
                 2316.19,2280.00,2255.87,2219.68,2195.56,2135.24,2111.11,$
                 2086.98,2062.86,2038.73,2002.54,1978.41,1954.28,1906.03,$
                 1881.90,1857.78,1833.65,1809.52,1785.40,1773.33,1749.21,$
                 1700.95,1676.83,1652.70,1640.63,1616.51,1592.38,1580.32,$
                 1556.19,1520.00,1495.87,1483.12,1459.68,1435.56,1423.49,$
                 1399.37,1375.24,1351.11,1339.05,1317.89,1301.15,1284.74,$
                 1268.33,1252.23,1220.70,1205.25,1190.12,1175.00,1159.87,$
                 1145.39,1130.91,1116.42,1088.42,1074.58,1060.75,1047.55,$
                 1034.04,1021.16,1007.97, 995.42, 970.31, 958.08, 945.85,$
                  933.95, 922.04, 910.13, 898.87, 887.28, 865.08, 854.13,$
                  843.19, 832.57, 821.95, 811.65, 801.35, 781.08, 771.10,$
                  761.45, 751.79, 742.14, 732.80, 723.47, 714.14, 696.44,$
                  687.43, 678.74, 670.05, 661.68, 653.31, 644.94, 636.90,$
                  620.81, 612.76, 605.04, 597.31, 589.91, 576.81, 575.11,$
                  567.70, 553.55, 546.46, 539.38, 532.63, 525.87, 519.11,$
                  512.67, 506.24, 493.36, 487.25, 480.81, 474.70, 468.90,$
                  462.79, 457.00, 445.41, 439.94, 434.15, 428.68, 423.20,$
                  418.05, 412.58, 407.43, 397.14, 391.99, 387.16, 382.33,$
                  377.50, 372.68, 367.85, 363.34, 354.01, 349.50, 345.00,$
                  340.82, 336.31, 332.13, 327.94, 323.76, 315.71, 311.53,$
                  307.67, 303.81, 299.94, 296.08, 292.54, 288.68, 281.28,$
                  277.74, 274.20, 270.98, 267.44, 263.90, 260.68, 254.24,$
                  251.03, 247.81,9650.79]
   endif
   end
