#include <stdio.h>
#include "defs.h"

int read_header(char *buffer, int buffersize, FILE *datafile)
{
        int i;
        uchar bytes[2];

        for (i=0; i<buffersize; i+=2) {
                if (fread(bytes, 1, 2, datafile) == 0)
                        return 1;

                if (check_byte_order() == LITTLE_ENDIAN)
                       convert_byte_order(bytes);

                memcpy(buffer+i, bytes, 2);
         }

        return 0;
}

int read_data(char *buffer, int buffersize, FILE *datafile)
{
        int i;
        uchar bytes[2];

        for (i=0; i<buffersize; i+=2) {
                if (fread(bytes, 1, 2, datafile) == 0)   
                        return 1;   

                memcpy(buffer+i, bytes, 2);
         }

        return 0;
}

int memcopy(char *dest, char *src, size_t size)
{
	int i;

	if (check_byte_order() == LITTLE_ENDIAN) {
		for (i=0; i<size/2; i+=2) {
                        dest[i] = src[size-i-2];
                        dest[i+1] = src[size-i-1];
                        dest[size-i-1] = src[i+1];
                        dest[size-i-2] = src[i];
		}
	} else {
		memcpy(dest, src, size);
	}
}
