#include "defs.h"
#include "load_header.h"
#include "buffers.h"

int4 load_cis_idl(int argc, void *argv[])
{
        char *filename;
        int4 *options;
        IDL_STRING *file_idl_str;
        buffer_info binfo;

	options = (int4 *)argv[0];
	file_idl_str = (IDL_STRING *)argv[1];
	
        filename = file_idl_str->s;
        binfo.sat = options[0];
        binfo.instr = options[1];
        binfo.prod = options[2];
        binfo.BM3 = options[3];
        
        return load_l1_file(filename, &binfo);
}

int4 get_cis_all_data(int argc, void *argv[])
{
	int4 *options, *cnt, *sizes, this_index;
	int buffer_index;
	buffer_info binfo;
	record_header *header;
	void *data;
	
	options = (int4 *)argv[0];
	cnt = (int4 *)argv[1];
	sizes = (int4 *)argv[2];
	header = (record_header *)argv[3];
	data = argv[4];
 
 	if (sizes[0] != sizeof(record_header)) {
 		printf("Size of IDL header structure not equal to C header size\r\n");
		printf("IDL size: %d, C size: %d\r\n",sizes[0],
			sizeof(record_header));
 		return 1;
 	}
 	
 	binfo.sat = options[0];
        binfo.instr = options[1];
        binfo.prod = options[2];
        binfo.BM3 = options[3];
	
	buffer_index = buffer_lookup(&binfo);
	
	if (buffer_index == -1) {
		printf("No corresponding buffer found\r\n");
		return 1;
	}

	for (this_index = 0; this_index < *cnt; this_index++) {	
		get_data_element(buffer_index,
			this_index, header+this_index,
			(char *)data+this_index*sizes[1],
			sizes[1]);
	}
	
	return 0;
}

int4 get_cis_data(int argc, void *argv[])
{
	int4 *options, *index, *sizes;
	int buffer_index;
	buffer_info binfo;
	record_header *header;
	void *data;
	
	options = (int4 *)argv[0];
	index = (int4 *)argv[1];
	sizes = (int4 *)argv[2];
	header = (record_header *)argv[3];
	data = argv[4];
 
 	if (sizes[0] != sizeof(record_header)) {
 		printf("Size of IDL header structure not equal to C header size\r\n");
		printf("IDL size: %d, C size: %d\r\n",sizes[0],
			sizeof(record_header));
 		return 1;
 	}
 	
 	binfo.sat = options[0];
        binfo.instr = options[1];
        binfo.prod = options[2];
        binfo.BM3 = options[3];
	
	buffer_index = buffer_lookup(&binfo);
	
	if (buffer_index == -1) {
		printf("No corresponding buffer found\r\n");
		return 1;
	}
	
	get_data_element(buffer_index, *index, header, data, sizes[1]);
	
	return 0;
}

int4 get_cis_data_by_time(int argc, void *argv[])
{
	int4 *options, *sizes, *index;
	double *time;
	int buffer_index;
	buffer_info binfo;
	record_header *header;
	void *data;
	
	options = (int4 *)argv[0];
	time = (double *)argv[1];
	sizes = (int4 *)argv[2];
	header = (record_header *)argv[3];
	data = argv[4];
	index = (int4 *)argv[5];
 
 	if (sizes[0] != sizeof(record_header)) {
 		printf("Size of IDL header structure not equal to C header size\r\n");
		printf("IDL size: %d, C size: %d\r\n",sizes[0],
			sizeof(record_header));
 		return 1;
 	}
 	
 	binfo.sat = options[0];
        binfo.instr = options[1];
        binfo.prod = options[2];
        binfo.BM3 = options[3];
	
	buffer_index = buffer_lookup(&binfo);
	
	if (buffer_index == -1) {
		printf("No corresponding buffer found\r\n");
		return 1;
	}
	
	get_data_by_time(buffer_index, time, header, data, sizes[1], index);
	
	return 0;
}

int4 get_cis_data_times(int argc, void *argv[])
{
	int4 *options, *index, *sizes;
	int buffer_index;
	buffer_info binfo;
	record_header *header;
	void *data;
	double *times;
	
	options = (int4 *)argv[0];
	times = (double *)argv[1];
 
 	binfo.sat = options[0];
        binfo.instr = options[1];
        binfo.prod = options[2];
        binfo.BM3 = options[3];
	
	buffer_index = buffer_lookup(&binfo);
	
	if (buffer_index == -1) {
		printf("No corresponding buffer found\r\n");
		return 1;
	}
	
	get_data_times(buffer_index, times);
	
	return 0;
}

int4 get_cis_data_count(int argc, void *argv[])
{
	int4 *options, *index, *sizes;
	int buffer_index;
	buffer_info binfo;
	int4 *cnt;
	
	options = (int4 *)argv[0];
	cnt = (int4 *)argv[1];
 
 	binfo.sat = options[0];
        binfo.instr = options[1];
        binfo.prod = options[2];
        binfo.BM3 = options[3];
	
	buffer_index = buffer_lookup(&binfo);
	
	if (buffer_index == -1) {
		printf("No corresponding buffer found\r\n");
		return 1;
	}
	
	get_data_count(buffer_index, cnt);
	
	return 0;
}
