#include <stdio.h>
#include <string.h>

#include "load_header.h"

int load_header(FILE *l1file, record_header *header)
{
	short b[28];
	double dblbuff;
	
	read_header( (char *) b, 28*sizeof(short) , l1file);
	
	header->indice = b[0];
	memcopy(&(header->time_in_ms),&b[1],sizeof(double));
	header->time_cis.day = b[5];
	memcopy(&(header->time_cis.milli),&b[6],sizeof(int));
	header->time_cis.micro = b[8];
	header->scet.day = b[9];
	memcopy(&(header->scet.milli),&b[10],sizeof(int));
	header->scet.micro = b[12];
	header->spin_frame = b[13];
	header->spin_packet = b[14];
	memcopy(&(header->pspin),&b[15],sizeof(float));
	header->sp_phase_pulse = b[17];
	header->sensitivity = b[18];
	header->tlm_rate = b[19];
	header->op_mode = b[20];
	header->burst_mode = b[21];
	header->type_produit = b[22];
	header->change_mode = b[23];
	header->phase_instr = b[24];
	header->type_instr = b[25];
	header->phase_codif = b[26];
	header->product_size = b[27];
	
	return 0;
}

int print_header(record_header *header)
{
	printf("indice: %d\r\n", header->indice);
	printf("time_in_ms: %g\r\n", header->time_in_ms);
	printf("time_cis\r\n");
	printf("\tday: %d\r\n", header->time_cis.day);
	printf("\tmilli: %u\r\n", header->time_cis.milli);
	printf("\tmicro: %d\r\n", header->time_cis.micro);
	printf("scet\r\n");
	printf("\tday: %d\r\n", header->scet.day);
	printf("\tmilli: %u\r\n", header->scet.milli);
	printf("\tmicro: %d\r\n", header->scet.micro);
	printf("spin_frame: %d\r\n", header->spin_frame);
	printf("spin_packet: %d\r\n", header->spin_packet);
	printf("pspin: %g\r\n", header->pspin);
	printf("sp_phase_pulse: %d\r\n", header->sp_phase_pulse);
	printf("sensitivity: %d\r\n", header->sensitivity);
	printf("tlm_rate: %d\r\n", header->tlm_rate);
	printf("op_mode: %d\r\n", header->op_mode);
	printf("burst_mode: %d\r\n", header->burst_mode);
	printf("type_produit: %d\r\n", header->type_produit);
	printf("change_mode: %d\r\n", header->change_mode);
	printf("phase_instr: %d\r\n", header->phase_instr);
	printf("type_instr: %d\r\n", header->type_instr);
	printf("phase_codif: %d\r\n", header->phase_codif);
	printf("product_size: %d\r\n", header->product_size);
	return 0;
}
