#include <stdio.h>
#include "defs.h"

/* Return the length (in bytes) of a file */
long file_length(FILE *file)
{
    long size;
    long crt_pos = ftell(file);

    fseek(file, 0, SEEK_END);
    size = ftell(file);
    fseek(file, crt_pos, SEEK_SET);
    return size;
}


/* Check if the machine is little or big-endian*/
int check_byte_order()
{
    short i = 1;
    uchar *bytes;

    
    bytes = (uchar *)&i;

    if (*bytes == 1)
        /* little endian\n") */
	return 1;
    else
        /* big endian */
	return 0;
}


/* Convert the words  from little-endian to big-endian byte-order*/
void convert_byte_order(uchar bytes[])
{
    uchar tmp;

    tmp = bytes[0];
    bytes[0] = bytes[1];
    bytes[1] = tmp;
}
