;+
;FUNCTION:      cis_tplot_time, cis_ms
;INPUT:
;	cis_ms: Time in CIS ms format.
;
;PURPOSE:   Convert CIS ms time format to TPLOT time format.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function cis_tplot_time,cis_ms

if cis_ms[0] lt 1d12 then return,cis_ms

days_to_1970 = julday(1,1,1970,0,0,0)-julday(1,1,1958,0,0,0)

sec_to_1970 = days_to_1970*24d*60d*60d

return,cis_ms/1000d - sec_to_1970

end
