;+
;FUNCTION:      get_cis_cal, dtime, sat, cal_type
;INPUT:
;       dtime: Time of interest in time_double format.
;	sat: Satellite number (1-4)
;	cal_type: String name of calibration data type to return. Possible
;		values are: 'MASS','P07','P09','P02','P04','CIS1','CIS2','EFF'
;
;PURPOSE:   Return calibration data in a structure.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
pro get_cis_cdata, dtime, sat, type_index, caldata, calinfo
@cis_com
sat = sat[0]
cal_arr = *((*cis_eff[sat-1]).catinfo)[type_index]
cal_ind = max(where(cal_arr.starttime le dtime))
caldata = (*((*cis_eff[sat-1]).catdata)[type_index])[cal_ind]
calinfo = (*((*cis_eff[sat-1]).catinfo)[type_index])[cal_ind]
end

pro put_caldata_in_comblock, caldata, dtime, sat, type_index
@cis_com
sat = sat[0]
cal_arr = *((*cis_eff[sat-1]).catinfo)[type_index]
cal_ind = max(where(cal_arr.starttime le dtime))
(*((*cis_eff[sat-1]).catdata)[type_index])[cal_ind] = ptr_new(caldata)
end

function get_cis_cal, dtime, sat, cal_type

@cis_com

if data_type(cal_type) eq 7 then begin
	type_index = where(strupcase(cal_type) eq cis_cal_types, cnt)
	if cnt eq 0 then begin
		print, 'No calibration type matching: '+cal_type
		return,0
	endif
endif else type_index = cal_type

type_index = type_index[0]

get_cis_cdata, dtime, sat, type_index, caldata, calinfo

if ptr_valid(caldata) then $
	return, *caldata $
else begin
	load_cis_cal_file, calinfo.filename, calret
	put_caldata_in_comblock, calret, dtime, sat, type_index
	return, calret
endelse

end
