;+
;FUNCTION:      get_cis_cal_filenames, sat, cattypes
;INPUT:
;       sat: Satellite number (1-4)
;	cattypes: Names of calibration file types.
;
;PURPOSE:   Return CIS calibration file names.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_cal_filenames, sat, cattypes

cal_dir = getenv('CLUSCAL')

cat_srh_str = '/C'+strcompress(string(sat),/rem)+'_L1_CISxxx_*_CALCATALOG.cal'

cat_files = findfile(cal_dir+cat_srh_str, count = filecnt)

if filecnt eq 0 then begin
	print, 'No Catalog Files Found!'
	return,0
endif

cat_version_pos = strlen(cat_files[0]) - 17
cat_version = 0

for i = 0, n_elements(cat_files)-1 do begin
	this_cat_version = fix(strmid(cat_files[i],cat_version_pos,2))
	if this_cat_version gt cat_version then begin
		cat_version = this_cat_version
		latest_cat_file = cat_files[i]
	endif
endfor

catinfo = ptrarr(n_elements(cattypes))
catentry = {starttime: 0d, filename: ''}

openr,catlun,latest_cat_file,/get_lun

aline = ''
latest_version = 0
while not eof(catlun) do begin
	repeat readf,catlun,aline until (strmid(aline,0,1) ne '#') and (aline ne '')
	aline_sepd = str_sep(strcompress(aline),' ')
	if aline[0] eq ' ' then aline = aline[1:*]
	version = fix(strmid(aline_sepd[2],1,3))
	if version gt latest_version then begin
		latest_version = version
	endif
endwhile

point_lun,catlun,0

while not eof(catlun) do begin
	repeat readf,catlun,aline until (strmid(aline,0,1) ne '#') and (aline ne '')
	aline_sepd = str_sep(strcompress(aline),' ')
	if aline[0] eq ' ' then aline = aline[1:*]
	catind = where(aline_sepd[0] eq cattypes, typecnt)
	catind = catind[0]
	if (typecnt ne 0) then begin
		version = fix(strmid(aline_sepd[2],1,3))
		if version eq latest_version then begin
			date = strmid(aline_sepd[1],0,10)
			dtime = strmid(aline_sepd[1],11,8)
			catentry.starttime = time_double(date+'/'+dtime)
			catentry.filename = aline_sepd[3]
			if ptr_valid(catinfo[catind]) then begin
				*catinfo[catind] = [catinfo[catind], catentry]
			endif else begin
				catinfo[catind] = ptr_new(catentry)
			endelse
		endif
	endif
endwhile

close,catlun
free_lun,catlun

catptrarr = ptrarr(n_elements(catinfo))
for i = 0,n_elements(catinfo)-1 do $
	catptrarr[i] = ptr_new(ptrarr(n_elements(*catinfo[i])))

return, {catinfo: catinfo, catdata: catptrarr}
end
