;+
;FUNCTION:      get_cis_cod_abseff, dtime, sat, sensitivity
;INPUT:
;       dtime: Time in time_double format
;	sat: Satellite number (1-4)
;	sensitivity: Sensitivity (Low = 0, High = 1)
;
;PURPOSE:   Retrieve CIS/CODIF absolute efficiency.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_cod_abseff,dtime, sat, sensitivity

cal_struct = get_cis_cal(dtime, sat, 'EFF')

return, double(cal_struct.absolute_efficiencies[sensitivity])

end
