;+
;FUNCTION:      get_cis_cod_accum_spins, dtime, sat, prod_num, tlm_rate,$
;	op_mode
;INPUT:
;       dtime: Time in time_double format
;	sat: Satellite number (1-4)
;	prod_num: Product number
;	tlm_rate: Telemetry rate (NM1, NM2,...)
;	op_mode: Operational mode (0-15)
;
;PURPOSE:   Retrieve CIS/CODIF spin accumulations.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_cod_accum_spins, dtime, sat, prod_num, tlm_rate, op_mode

cal_struct = get_cis_cal(dtime, sat, 'CIS1')

case tlm_rate of
	1: tlm_srch = 'NM1'
	2: tlm_srch = 'NM2'
	3: tlm_srch = 'NM3'
	4: tlm_srch = 'BM1'
	5: tlm_srch = 'BM2'
	6: tlm_srch = 'BM3'
endcase

spin_table = cal_struct.accumulation_spin_table

prod_ind = where(long(spin_table[0,*]) eq prod_num)
spin_table = spin_table[*,prod_ind]

tlm_ind = where(spin_table[1,*] eq tlm_srch)
spin_table = spin_table[*,tlm_ind]

return,long(spin_table[op_mode+2])

end
