;+
;PROCEDURE:      get_cis_cod_angles, nangles, theta, phi, dtheta, dphi
;INPUT:
;       nangles: Number of angle bins
;	theta: Variable to return theta values
;	phi: Variable to return phi values
;	dtheta: Variable to return dtheta values
;	dphi: Variable to return dphi values
;
;PURPOSE:   Calculate CIS/CODIF angle bins.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
pro get_cis_cod_angles, nangles, theta, phi, dtheta, dphi

theta12A = $
[ 67.5, 67.5, $ 
  22.5, 22.5, 22.5, 22.5, $
  -22.5, -22.5, -22.5, -22.5, $
  -67.5, -67.5 $
]
 
theta24A = $
[ 78.75, 78.75, 56.25, 56.25, 33.75, 33.75, 33.75, 33.75, $
  11.25, 11.25, 11.25, 11.25, -11.25, -11.25, -11.25, -11.25, $
  -33.75, -33.75, -33.75, -33.75, -56.25, -56.25, -78.75, -78.75 $
]

theta88A = $
[ 78.75, 78.75, 78.75, 78.75, $
  56.25, 56.25, 56.25, 56.25, 56.25, 56.25, 56.25, 56.25,$
  33.75, 33.75, 33.75, 33.75, 33.75, 33.75, 33.75, 33.75,$
  33.75, 33.75, 33.75, 33.75, 33.75, 33.75, 33.75, 33.75,$
  11.25, 11.25, 11.25, 11.25, 11.25, 11.25, 11.25, 11.25,$
  11.25, 11.25, 11.25, 11.25, 11.25, 11.25, 11.25, 11.25,$
  -11.25, -11.25, -11.25, -11.25, -11.25, -11.25, -11.25, -11.25,$
  -11.25, -11.25, -11.25, -11.25, -11.25, -11.25, -11.25, -11.25,$
  -33.75, -33.75, -33.75, -33.75, -33.75, -33.75, -33.75, -33.75, $
  -33.75, -33.75, -33.75, -33.75, -33.75, -33.75, -33.75, -33.75, $
  -56.25, -56.25, -56.25, -56.25, -56.25, -56.25, -56.25, -56.25, $
  -78.75, -78.75, -78.75, -78.75 $
]

phi12A = float([90, 270, 45, 135, 225, 315, 45, 135, 225, 315, 90, 270])

delta_phi12A = float([180, 180, 90, 90, 90, 90, 90, 90, 90, 90, 180, 180])

phi24A = float([90, 270, 90, 270, $
45, 135, 225, 315, 45, 135, 225, 315, $
45, 135, 225, 315, 45, 135, 225, 315, $
90, 270, 90, 270 $
])

delta_phi24A = $
float([180, 180, 180, 180, 90, 90, 90, 90, 90, 90, 90, 90, $
 90, 90, 90, 90, 90, 90, 90, 90, 180, 180, 180, 180])

phi88A = $
[ 45, 135, 225, 315,$
  22.5, 67.5, 112.5, 157.5, 202.5, 247.5, 292.5, 337.5,$
  11.25, 33.75, 56.25, 78.75, 101.25, 123.75, 146.25, 168.75, $
  191.25, 213.75, 236.25, 258.75, 281.25, 303.75, 326.25, 348.75,$
  11.25, 33.75, 56.25, 78.75, 101.25, 123.75, 146.25, 168.75, $
  191.25, 213.75, 236.25, 258.75, 281.25, 303.75, 326.25, 348.75,$
  11.25, 33.75, 56.25, 78.75, 101.25, 123.75, 146.25, 168.75, $
  191.25, 213.75, 236.25, 258.75, 281.25, 303.75, 326.25, 348.75,$
  11.25, 33.75, 56.25, 78.75, 101.25, 123.75, 146.25, 168.75, $
  191.25, 213.75, 236.25, 258.75, 281.25, 303.75, 326.25, 348.75,$
  22.5, 67.5, 112.5, 157.5, 202.5, 247.5, 292.5, 337.5,$
  45, 135, 225, 315 $
]

delta_phi88A = $
[90, 90, 90, 90,$
 45, 45, 45, 45, 45, 45, 45, 45,$
 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5,$
 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5,$
 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5,$
 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5,$
 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5,$
 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5,$
 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5,$
 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5, 22.5,$
 45, 45, 45, 45, 45, 45, 45, 45,$
 90, 90, 90, 90]

theta6_min = $
float([ 45, -45, -45, -45, -45, -90])

theta6_max = $
float([ 90, 45, 45, 45, 45, -45])

theta6_avg = $
float([ 67.5, 0, 0, 0, 0, -67.5])

phi6_min = $
float([0, 0, 90, 180, 270, 0])

phi6_max = $
float([ 360, 90, 180, 270, 360, 360])

phi6_avg = $
float([180, 45, 135, 225, 315, 180])

ang8min = $
float([0, 22.5, 45, 67.5, 90, 112.5, 135, 157.5])

ang8max = $
float([ 22.5, 45, 67.5, 90, 112.5, 135, 157.5, 180])

ang8avg = $
float([11.25, 33.75, 56.25, 78.75, 101.25, 123.75, 146.25, 168.75])

delta_theta6 = theta6_max - theta6_min
delta_phi6 = phi6_max - phi6_min

delta_theta12 = replicate(45.,12)
delta_theta24 = replicate(22.5,24)
delta_theta88 = replicate(22.5,88)

case nangles of
	12: begin
		theta = theta12A
		phi = phi12A
		dtheta = delta_theta12
		dphi = delta_phi12A
	end
	24: begin
		theta = theta24A
		phi = phi24A
		dtheta = delta_theta24
		dphi = delta_phi24A
	end
	88: begin
		theta = theta88A
		phi = phi88A
		dtheta = delta_theta88
		dphi = delta_phi88A
	end
	6: begin
		theta = theta6_avg
		phi = phi6_avg
		dtheta = delta_theta6
		dphi = delta_phi6
	end
endcase

return
end

