;+
;FUNCTION:      get_cis_cod_data, prod_num, sat, t, index=index, time=time
;INPUT:
;       prod_num: Product number
;       t: Time of interest*
;       index: Data index (alternative to using t)*
;       sat: Satellite number (1-4)
;       time: If set, return time array of data values (index ignored)
;
;	*NOTE: t and index are ignored for 3D data products.  Function will
;		return data for all times/indices.
;
;PURPOSE:   Retrieve CIS/CODIF data.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  September 2000
;
;-
function get_cis_cod_data, prod_num, sat, t, index=index, time=time

if not keyword_set(t) then t = 0

case prod_num of
	1: return, get_cis_cod_p1(sat, t, index=index, time=time)
	2: return, get_cis_cod_p2(sat, t, index=index, time=time)
	3: return, get_cis_cod_p3(sat, t, index=index, time=time)
	4: return, get_cis_cod_p4(sat, t, index=index, time=time)
	5: return, get_cis_cod_p5(sat, t, index=index, time=time)
	6: return, get_cis_cod_p6(sat, t, index=index, time=time)
	7: return, get_cis_cod_p7(sat, t, index=index, time=time)
	9: return, get_cis_cod_p9(sat, t, index=index, time=time)
	11: return, get_cis_cod_p11(sat, t, index=index, time=time)
	12: return, get_cis_cod_3d(prod_num, sat, time=time)
	13: return, get_cis_cod_3d(prod_num, sat, time=time)
	14: return, get_cis_cod_3d(prod_num, sat, time=time)
	15: return, get_cis_cod_3d(prod_num, sat, time=time)
	16: return, get_cis_cod_3d(prod_num, sat, time=time)
	17: return, get_cis_cod_3d(prod_num, sat, time=time)
	18: return, get_cis_cod_3d(prod_num, sat, time=time)
	19: return, get_cis_cod_2d(prod_num, sat, t, index=index, time=time)
	20: return, get_cis_cod_2d(prod_num, sat, t, index=index, time=time)
	21: return, get_cis_cod_2d(prod_num, sat, t, index=index, time=time)
	22: return, get_cis_cod_2d(prod_num, sat, t, index=index, time=time)
	23: return, get_cis_cod_pac(prod_num, sat, t, index=index, time=time)
	24: return, get_cis_cod_pac(prod_num, sat, t, index=index, time=time)
	27: return, get_cis_cod_p27(sat, t, index=index, time=time)
	29: return, get_cis_cod_p29(sat, t, index=index, time=time)
	36: return, get_cis_cod_p36(sat, t, index=index, time=time)
	38: return, get_cis_cod_p38(sat, t, index=index, time=time)
	46: return, get_cis_cod_3d(prod_num, sat, time=time)
	47: return, get_cis_cod_3d(prod_num, sat, time=time)
	48: return, get_cis_cod_3d(prod_num, sat, time=time)
	49: return, get_cis_cod_3d(prod_num, sat, time=time)
	61: return, get_cis_cod_p61(sat, t, index=index, time=time)
	62: return, get_cis_cod_p62(sat, t, index=index, time=time)
endcase

print,'No Product Matching Product Number ',prod_num
return,0
end

