;+
;PROCEDURE:     get_cis_cod_energies, dtime, sat, nenergy, tel_mode, $
;       sensitivity, energy, denergy
;INPUT:
;       dtime: Time of interest in time_double format.
;       sat: Satellite number (1-4)
;       nenergy: Number of energy bins
;       tel_mode: Telemetry mode (0-15)
;       sensitivity: Sensitivity (Low = 0, High = 1)
;       energy: Variable to return energy values
;       denergy: Variable to return denergy values
;
;PURPOSE:   Calculate CIS/CODIF energy bins.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
pro get_cis_cod_energies, dtime, sat, nenergy, tel_mode, sensitivity, energy,$
	denergy

cal_struct = get_cis_cal(dtime, sat, 'CIS1')

case 1 of
	((tel_mode ge 8) and (tel_mode le 15)) or (tel_mode eq 6): begin
		vmax = float(cal_struct.energy_sweep_table_mag[0])
		k = float(cal_struct.energy_sweep_table_mag[1])
	end
	tel_mode le 5: begin
		vmax = float(cal_struct.energy_sweep_table_sw[0])
		k = float(cal_struct.energy_sweep_table_sw[1])
	end
	tel_mode eq 7: begin
		vmax = float(cal_struct.energy_sweep_table_prom[0])
		k = float(cal_struct.energy_sweep_table_prom[1])
	end
endcase

anal_k_factor = float(cal_struct.anal_k_factor[sensitivity])

energy_upper = fltarr(128)

for i = 0,127 do $
	energy_upper[i] = anal_k_factor*vmax*k^i

energy_lower = [energy_upper[1:127],16.4001]

energy = fltarr(nenergy)
denergy = energy
comp_factor = 128/nenergy

for i = 0,nenergy-1 do begin
	energy[i] = (energy_upper[i*comp_factor] + $
		energy_lower[(i+1)*comp_factor-1])/2.
	denergy[i] = energy_upper[i*comp_factor] - $
		energy_lower[(i+1)*comp_factor-1]
endfor

return
end
