;+
;FUNCTION:      get_cis_cod_geom_factor, dtime, sat, sensitivity
;INPUT:
;	dtime: Time in time_double format
;	sat: Satellite number (1-4)
;	sensitivity: Sensitivity (Low = 0, High = 1)
;
;PURPOSE:   Retrieve CIS/CODIF geometric factor.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_cod_geom_factor,dtime, sat, sensitivity

cal_struct = get_cis_cal(dtime, sat, 'CIS1')

return, double(cal_struct.geom_factor[sensitivity])

end
