;+
;FUNCTION:      get_cis_cod_mom_corr, dtime, sat, sensitivity, prod_num
;INPUT:
;	dtime: Time in time_double format
;	sat: Satellite number (1-4)
;	sensitivity: Sensitivity (Low = 0, High = 1)
;	prod_num: Product number
;
;PURPOSE:   Retrieve CIS/CODIF moment correction.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_cod_mom_corr,dtime, sat, sensitivity, prod_num

if prod_num eq 7 then cal_name = 'P07' else cal_name = 'P09'

cal_struct = get_cis_cal(dtime, sat, cal_name)

a = get_cis_data_array([sat,0,7,0])
b = a

if sensitivity eq 0 then $
	cal_indx = where(cal_struct[2,*] eq 'LS') $
else $
	cal_indx = where(cal_struct[2,*] eq 'HS')

cal_struct = cal_struct(*,cal_indx)

a[0,0,0] = cal_struct[4,0]
a[0,0,1] = cal_struct[4,1]
a[0,0,2] = cal_struct[4,2]
a[0,1,0] = cal_struct[4,3]
a[0,1,1] = cal_struct[4,4]
a[0,1,2] = cal_struct[4,5]
a[0,2,0] = cal_struct[4,6]
a[0,2,1] = cal_struct[4,7]
a[0,2,2] = cal_struct[4,8]
a[0,3,0] = cal_struct[4,9]
a[0,3,1] = cal_struct[4,10]
a[0,3,2] = cal_struct[4,11]

a[1,0,0] = cal_struct[4,12]
a[4,0,0] = cal_struct[4,12]
a[2,0,0] = cal_struct[4,13]
a[5,0,0] = cal_struct[4,13]
a[3,0,0] = cal_struct[4,14]
a[6,0,0] = cal_struct[4,14]
a[1,0,1] = cal_struct[4,15]
a[4,0,1] = cal_struct[4,15]
a[2,0,1] = cal_struct[4,16]
a[5,0,1] = cal_struct[4,16]
a[3,0,1] = cal_struct[4,17]
a[6,0,1] = cal_struct[4,17]
a[1,0,2] = cal_struct[4,18]
a[4,0,2] = cal_struct[4,18]
a[2,0,2] = cal_struct[4,19]
a[5,0,2] = cal_struct[4,19]
a[3,0,2] = cal_struct[4,20]
a[6,0,2] = cal_struct[4,20]
a[1:6,1,*] = a[1:6,0,*]
a[1:6,2,*] = a[1:6,0,*]
a[1,3,0] = cal_struct[4,21]
a[4,3,0] = cal_struct[4,21]
a[2,3,0] = cal_struct[4,22]
a[5,3,0] = cal_struct[4,22]
a[3,3,0] = cal_struct[4,23]
a[6,3,0] = cal_struct[4,23]
a[1,3,1] = cal_struct[4,24]
a[4,3,1] = cal_struct[4,24]
a[2,3,1] = cal_struct[4,25]
a[5,3,1] = cal_struct[4,25]
a[3,3,1] = cal_struct[4,26]
a[6,3,1] = cal_struct[4,26]
a[1,3,2] = cal_struct[4,27]
a[4,3,2] = cal_struct[4,27]
a[2,3,2] = cal_struct[4,28]
a[5,3,2] = cal_struct[4,28]
a[3,3,2] = cal_struct[4,29]
a[6,3,2] = cal_struct[4,29]

a[7,*,0] = cal_struct[4,30]
a[10,*,0] = cal_struct[4,31]
a[11,*,0] = cal_struct[4,32]
a[8,*,0] = cal_struct[4,33]
a[12,*,0] = cal_struct[4,34]
a[9,*,0] = cal_struct[4,35]
a[7,*,1] = cal_struct[4,36]
a[10,*,1] = cal_struct[4,37]
a[11,*,1] = cal_struct[4,38]
a[8,*,1] = cal_struct[4,39]
a[12,*,1] = cal_struct[4,40]
a[9,*,1] = cal_struct[4,41]
a[7,*,2] = cal_struct[4,42]
a[10,*,2] = cal_struct[4,43]
a[11,*,2] = cal_struct[4,44]
a[8,*,2] = cal_struct[4,45]
a[12,*,2] = cal_struct[4,46]
a[9,*,2] = cal_struct[4,47]

b[0,0,0] = cal_struct[5,0]
b[0,0,1] = cal_struct[5,1]
b[0,0,2] = cal_struct[5,2]
b[0,1,0] = cal_struct[5,3]
b[0,1,1] = cal_struct[5,4]
b[0,1,2] = cal_struct[5,5]
b[0,2,0] = cal_struct[5,6]
b[0,2,1] = cal_struct[5,7]
b[0,2,2] = cal_struct[5,8]
b[0,3,0] = cal_struct[5,9]
b[0,3,1] = cal_struct[5,10]
b[0,3,2] = cal_struct[5,11]

b[1,0,0] = cal_struct[5,12]
b[4,0,0] = cal_struct[5,12]
b[2,0,0] = cal_struct[5,13]
b[5,0,0] = cal_struct[5,13]
b[3,0,0] = cal_struct[5,14]
b[6,0,0] = cal_struct[5,14]
b[1,0,1] = cal_struct[5,15]
b[4,0,1] = cal_struct[5,15]
b[2,0,1] = cal_struct[5,16]
b[5,0,1] = cal_struct[5,16]
b[3,0,1] = cal_struct[5,17]
b[6,0,1] = cal_struct[5,17]
b[1,0,2] = cal_struct[5,18]
b[4,0,2] = cal_struct[5,18]
b[2,0,2] = cal_struct[5,19]
b[5,0,2] = cal_struct[5,19]
b[3,0,2] = cal_struct[5,20]
b[6,0,2] = cal_struct[5,20]
b[1:6,1,*] = b[1:6,0,*]
b[1:6,2,*] = b[1:6,0,*]
b[1,3,0] = cal_struct[5,21]
b[4,3,0] = cal_struct[5,21]
b[2,3,0] = cal_struct[5,22]
b[5,3,0] = cal_struct[5,22]
b[3,3,0] = cal_struct[5,23]
b[6,3,0] = cal_struct[5,23]
b[1,3,1] = cal_struct[5,24]
b[4,3,1] = cal_struct[5,24]
b[2,3,1] = cal_struct[5,25]
b[5,3,1] = cal_struct[5,25]
b[3,3,1] = cal_struct[5,26]
b[6,3,1] = cal_struct[5,26]
b[1,3,2] = cal_struct[5,27]
b[4,3,2] = cal_struct[5,27]
b[2,3,2] = cal_struct[5,28]
b[5,3,2] = cal_struct[5,28]
b[3,3,2] = cal_struct[5,29]
b[6,3,2] = cal_struct[5,29]

b[7,*,0] = cal_struct[5,30]
b[10,*,0] = cal_struct[5,31]
b[11,*,0] = cal_struct[5,32]
b[8,*,0] = cal_struct[5,33]
b[12,*,0] = cal_struct[5,34]
b[9,*,0] = cal_struct[5,35]
b[7,*,1] = cal_struct[5,36]
b[10,*,1] = cal_struct[5,37]
b[11,*,1] = cal_struct[5,38]
b[8,*,1] = cal_struct[5,39]
b[12,*,1] = cal_struct[5,40]
b[9,*,1] = cal_struct[5,41]
b[7,*,2] = cal_struct[5,42]
b[10,*,2] = cal_struct[5,43]
b[11,*,2] = cal_struct[5,44]
b[8,*,2] = cal_struct[5,45]
b[12,*,2] = cal_struct[5,46]
b[9,*,2] = cal_struct[5,47]

return, {a: a, b: b}

end
