;+
;PROCEDURE:     get_cis_cod_moments, sat, cold=cold
;PURPOSE:
;  Creates "TPLOT" variable of CIS/CODIF moment data.
;
;INPUT:         sat: Satellite number
;
;KEYWORDS:      cold: If set, load cold moments.
;
;CREATED BY:    Peter Schroeder
;-
function fill_moment_struct, mom_data

mom_struct = {cis_moment, N: mom_data[0], V: mom_data[1:3], $
	H: mom_data[4:6], P: mom_data[7:12]}

return, mom_struct
end

pro get_cis_cod_moments, sat, cold=cold

if keyword_set(cold) then begin
	prod_num = 9
	tname = 'COD_COLD_MOM'
endif else begin
	prod_num = 7
	tname = 'COD_MOM'
endelse

t = get_cis_cod_data(prod_num, sat, /time)

if not keyword_set(t) then begin
	load_cis_data,sat,0,prod_num
	t = get_cis_cod_data(prod_num, sat, /time)
	if not keyword_set(t) then return
endif

cnt = n_elements(t)

mom_struct = {cis_moment, N: 0., V: fltarr(3), H: fltarr(3), P: fltarr(6)}

dat0 = {time: 0d, H1_E1: mom_struct, H1_E2: mom_struct, H1_E3: mom_struct, $
	He2_E1: mom_struct, He2_E2: mom_struct, He2_E3: mom_struct, $
	He1_E1: mom_struct, He1_E2: mom_struct, He1_E3: mom_struct, $
	O1_E1: mom_struct, O1_E2: mom_struct, O1_E3: mom_struct}

data = replicate(dat0, cnt)

for i = 0, cnt-1 do begin
	this_dat = get_cis_cod_data(prod_num, sat, index=i)
	if not keyword_set(this_dat) then return
	data[i].time = this_dat.time
	data[i].H1_E1 = fill_moment_struct(this_dat.data[*,0,0])
	data[i].H1_E2 = fill_moment_struct(this_dat.data[*,0,1])
	data[i].H1_E3 = fill_moment_struct(this_dat.data[*,0,2])
	data[i].He2_E1 = fill_moment_struct(this_dat.data[*,1,0])
	data[i].He2_E2 = fill_moment_struct(this_dat.data[*,1,1])
	data[i].He2_E3 = fill_moment_struct(this_dat.data[*,1,2])
	data[i].He1_E1 = fill_moment_struct(this_dat.data[*,2,0])
	data[i].He1_E2 = fill_moment_struct(this_dat.data[*,2,1])
	data[i].He1_E3 = fill_moment_struct(this_dat.data[*,2,2])
	data[i].O1_E1 = fill_moment_struct(this_dat.data[*,3,0])
	data[i].O1_E2 = fill_moment_struct(this_dat.data[*,3,1])
	data[i].O1_E3 = fill_moment_struct(this_dat.data[*,3,2])
endfor

store_data,tname,data=data

return
end
