;+
;FUNCTION:      get_cis_cod_p9, sat, t, index=index, time=time
;INPUT:
;	t: Time of interest
;	index: Data index to retrieve (alternative to using t)
;	sat: Satellite number (1-4)
;	time: If set, return time array of data values
;
;PURPOSE:   Retrieve CIS/CODIF P9 data.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_cod_p9, sat, t, index=index, time=time

prod_num = 9
options = [long(sat),0l,long(prod_num),0l]
if keyword_set(time) then return,get_cis_data_times(options)

if arg_present(index) then $
	basic_data = get_cis_data(options,index) $
else basic_data = get_cis_data_by_time(options,time_double(t),index)

if not keyword_set(basic_data) then return, 0

dtime = cis_tplot_time(basic_data.header.time_in_ms)
sensitivity = basic_data.header.sensitivity

mom_corr = get_cis_cod_mom_corr(dtime, sat, sensitivity, prod_num)

data = basic_data.data
data = data*mom_corr.a + mom_corr.b
delta_t = basic_data.header.pspin/1d3

retdata = { $
        project_name: 'CLUSTER CODIF', $
        data_product: prod_num, $
        units_name: 'Counts', $
	time: cis_tplot_time(basic_data.header.time_in_ms), $
        delta_t: delta_t, $
        integ_t: delta_t, $
        geom_factor: get_cis_cod_geom_factor(dtime, sat, sensitivity), $
	index: long(index), $
        eff: get_cis_cod_abseff(dtime, sat, sensitivity), $
	data: data }
	
return, retdata
end
