;+
;FUNCTION:      get_cis_cod_pac, prod_num, sat, t, index=index, time=time
;INPUT:
;       prod_num: Product number (23 or 24)
;	t: Time of interest
;	index: Data index to retrieve (alternative to using t)
;	sat: Satellite number (1-4)
;	time: If set, return time array of data values
;
;PURPOSE:   Retrieve CIS/CODIF Pitch Angle Cut data.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_cod_pac, prod_num, sat, t, index=index, time=time

case prod_num of
	23: nenergy = 16
	24: nenergy = 31
endcase

options = [long(sat),0l,long(prod_num),0l]
if keyword_set(time) then return,get_cis_data_times(options)

if arg_present(index) then $
	basic_data = get_cis_data(options,index) $
else basic_data = get_cis_data_by_time(options,time_double(t),index)

if not keyword_set(basic_data) then return, 0

dtime = cis_tplot_time(basic_data.header.time_in_ms)
op_mode = basic_data.header.op_mode
sensitivity = basic_data.header.sensitivity
get_cis_cod_energies,dtime,sat,nenergy,op_mode,sensitivity,energy,denergy

tlm_rate = basic_data.header.tlm_rate
num_spins = get_cis_cod_accum_spins(dtime, sat, prod_num, tlm_rate, op_mode)
delta_t = num_spins*basic_data.header.pspin/1d3

retdata = { $
	project_name: 'CLUSTER CODIF', $
	data_product: prod_num, $
	units_name: 'Counts', $
	time: dtime, $
	delta_t: delta_t, $
	integ_t: delta_t, $
	geom_factor: get_cis_cod_geom_factor(dtime, sat, sensitivity), $
	index: long(index), $
	energy: energy, $
	denergy: denergy, $
	eff: get_cis_cod_abseff(dtime, sat, sensitivity), $
	bx: basic_data.data.bx, $
	by: basic_data.data.by, $
	bz: basic_data.data.bz, $
	sweeping_number: basic_data.data.sn, $
	data: basic_data.data.data }
	
return, retdata
end
