;+
;FUNCTION:	get_cis_data_array, options
;INPUT:
;    options: lonarr(4), an array of values specifying the type of data to
;    	load.  Values correspond to:
;	options[0]: Satellite number (1-4)
;	options[1]: Instrument (0: CODIF, 1: HIA)
;	options[2]: Product number
;	options[3]: BM3 Flag (0: Normal, 1: BM3)
;
;PURPOSE:   Return empty data array for a given product.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  June 2000
;
;-
function get_cod_data_array, prod

case prod of
	1: data = lonarr(32,48)
	2: data = lonarr(32,48)
	3: data = intarr(7,1024)
	4: data = intarr(5,512)
	5: data = intarr(3,32)
	6: data = intarr(5,80)
	7: data = fltarr(13,4,3)
	9: data = fltarr(13,4,3)
	11: data = lonarr(8,6,64)
	12: data = {k1: 0, k2: 0, data: lonarr(16,88)}
	13: data = {k1: 0, k2: 0, data: lonarr(31,88)}
	14: data = {k1: 0, k2: 0, data: lonarr(31,24)}
	15: data = {k1: 0, k2: 0, data: lonarr(16,88)}
	16: data = {k1: 0, k2: 0, data: lonarr(31,88)}
	17: data = {k1: 0, k2: 0, data: lonarr(16,88,2)}
	18: data = {k1: 0, k2: 0, data: lonarr(31,88,2)}
	19: data = lonarr(31,16,4)
	20: data = lonarr(16,8,4)
	21: data = lonarr(16,16,2)
	22: data = lonarr(31,32)
	23: data = {bx: 0, by: 0, bz: 0, sn: 0, data: lonarr(16,8,4)}
	24: data = {bx: 0, by: 0, bz: 0, sn: 0, data: lonarr(31,8,4)}
	27: data = lonarr(18,16,16)
	28: data = intarr(5,48)
	29: data = {anode: 0l, data: lonarr(16,88,4)}
	36: data = intarr(32,8,16,4)
	38: begin
		e = lonarr(4,3)
		s = {spin_counter: 0, padding: 0, e: e}
		data = { $
			spin_samples: replicate(s, 5), $
			averages: {temp: 0l, e: e}, $
			trigger_thresholds: {sample_ptr: 0, ctr: 0, e: e} }
	end
	46: data = {k1: 0, k2: 0, data: lonarr(16,88)}
	47: data = {k1: 0, k2: 0, data: lonarr(16,88)}
	48: data = {k1: 0, k2: 0, data: lonarr(31,88)}
	49: data = {k1: 0, k2: 0, data: lonarr(31,88)}
	61: data = intarr(2)
	62: data = intarr(257)
else: data = 0
endcase

return, data
end

function get_hia_data_array, prod

case prod of
	0: data = intarr(32,2)
	1: data = lonarr(32,48)
	2: data = fltarr(13,3)
	4: data = {hvtbl: 0, eband: 0, data: fltarr(13,2)}
	5: data = {fore_acc_spins: 0, real_acc_spins: 0, data: lonarr(62,8,16)}
	6: data = { $
		hvtbl: 0, $
		eband: 0, $
		fore_acc_spins: 0, $
		real_acc_spins: 0, $
		data: lonarr(31,88) }
	7: data = {fore_acc_spins: 0, real_acc_spins: 0, data: lonarr(31,42)}
	8: data = {hvtbl: 0, eband: 0, data: lonarr(31,8,8)}
	9: data = intarr(62)
	10: data = { $
		hvtbl: 0, $
		eband: 0, $
		fore_acc_spins: 0, $
		real_acc_spins: 0, $
		data: lonarr(31,16) }
	11: data = lonarr(31,16)
	12: data = {startup_phase: 0, first_pad: 0, data: lonarr(31,16,2) }
	13: data = {hvtbl: 0, eband: 0, data: lonarr(31,8)}
	14: data = {hvtbl: 0, eband: 0, data: lonarr(31,8)}
	15: data = { $
		hvtbl: 0, $
		eband: 0, $
		fore_acc_spins: 0, $
		real_acc_spins: 0, $
		data: lonarr(16,88) }
	16: data = { $
		hvtbl: 0, $
		eband: 0, $
		fore_acc_spins: 0, $
		real_acc_spins: 0, $
		data: lonarr(30,88) }
	17: data = {fore_acc_spins: 0, real_acc_spins: 0, data: lonarr(62,88)}
	18: data = lonarr(31)
	19: begin
		slice = {startup_phase: 0, first_pad: 0, data: lonarr(31,16)}
		data = {indicator: 0l, data: replicate(slice, 2)}
	end
	20: data = {hvtbl: 0, eband: 0, data: lonarr(31,16,3)}
	21: data = {fore_acc_spins: 0, real_acc_spins: 0, $
		data: lonarr(31,8,16)}
	22: data = {hvtbl: 0, eband: 0, data: lonarr(31,8,16)}
	23: data = { $
		hvtbl: 0, $
		eband: 0, $
		fore_acc_spins: 0, $
		real_acc_spins: 0, $
		k1: 0, $
		k2: 0, $
		data: lonarr(31,8,16) }
	24: data = { $
		hvtbl: 0, $
		eband: 0, $
		k1: 0, $
		k2: 0, $
		data: lonarr(31,8,8) }
	61: data = intarr(2)
	62: data = intarr(257)
else: data = 0
endcase

return,data
end

function get_cis_data_array, options

case options[1] of
	0: return, get_cod_data_array(options[2])
	1: return, get_hia_data_array(options[2])
else: return, 0
endcase

end
