;+
;FUNCTION:	get_cis_data_by_time, options, index
;INPUT:
;    options: lonarr(4), an array of values specifying the type of data to
;    	retrieve.  Values correspond to:
;	options[0]: Satellite number (1-4)
;	options[1]: Instrument (0: CODIF, 1: HIA)
;	options[2]: Product number
;	options[3]: BM3 Flag (0: Normal, 1: BM3)
;    time: in time_double readable format
;    index: variable to return index of data record
;
;PURPOSE:   Retrieve Cluster/CIS data from memory.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_data_by_time, options, time, index

l1toidl_lib = getenv('L1TOIDL_LIB')

options = long(options)

cnt = 0l

err = call_external(l1toidl_lib,'get_cis_data_count',options,cnt)

if cnt eq 0 then begin
	load_cis_data,options[0],options[1],options[2],bm3=options[3]
	err = call_external(l1toidl_lib,'get_cis_data_count',options,cnt)
	if cnt eq 0 then return,0
endif

ctime = {CDS_time, $
	day: 0, $
	milli: 0l, $
	micro: 0 }
	
header = { $
	indice: 0, $
	time_in_ms: 0d, $
	time_cis: {CDS_time}, $
	scet: {CDS_time}, $
	spin_frame: 0, $
	spin_packet: 0, $
	pspin: 0., $
	sp_phase_pulse: 0, $
	sensitivity: 0, $
	tlm_rate: 0, $
	op_mode: 0, $
	burst_mode: 0, $
	type_produit: 0, $
	change_mode: 0, $
	phase_instr: 0, $
	type_instr: 0, $
	phase_codif: 0, $
	product_size: 0 }

data = get_cis_data_array(options)

header_size = n_tags(header,/length)
data_size = n_tags({foo: data},/length)

sizes = [header_size, data_size]
index = 0l

err = call_external(l1toidl_lib,'get_cis_data_by_time',options,$
	time_double(time),sizes,header,data,index)

retdata = { $
	header: header, $
	data: data }

return,retdata
end
