;+
;FUNCTION:	get_cis_data_times, options
;INPUT:
;    options: lonarr(4), an array of values specifying the type of data to
;    	retrieve.  Values correspond to:
;	options[0]: Satellite number (1-4)
;	options[1]: Instrument (0: CODIF, 1: HIA)
;	options[2]: Product number
;	options[3]: BM3 Flag (0: Normal, 1: BM3)
;
;PURPOSE:   Retrieve Cluster/CIS data times from memory.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_data_times, options

l1toidl_lib = getenv('L1TOIDL_LIB')

options = long(options)

cnt = 0l

err = call_external(l1toidl_lib,'get_cis_data_count',options,cnt)

if cnt eq 0 then return,0

times = dblarr(cnt)
err = call_external(l1toidl_lib,'get_cis_data_times',options,times)

return,cis_tplot_time(times)
end
