;+
;FUNCTION:	get_cis_filename, options
;INPUT:
;    options: lonarr(4), an array of values specifying the type of data to
;    	load.  Values correspond to:
;	options[0]: Satellite number (1-4)
;	options[1]: Instrument (0: CODIF, 1: HIA)
;	options[2]: Product number
;	options[3]: BM3 Flag (0: Normal, 1: BM3)
;
;PURPOSE:   Produce search string to find a CIS L1 file.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  June 2000
;
;-
function get_cis_filename,options,date_str

sat = options[0]
instr = options[1]
prod = options[2]
BM3 = options[3]

sat_str = 'C'+strcompress(sat,/remove_all)+'_'

level_str = 'L1_'

case (instr) of
	0:	instr_str = 'CISCOD_'
	1:	instr_str = 'CISHIA_'
else: return,0
endcase

version_str = '_V*_'

case (BM3) of
	0:	prod_str = '*_'+strcompress(prod,/remove_all)+'[x.]*'
	1:	prod_str = '*BM3_'+strcompress(prod,/remove_all)+'[x.]*'
else: return,0
endcase

ext_str = 'sdd'

return,sat_str+level_str+instr_str+date_str+version_str+prod_str+ext_str
end
