;+
;PROCEDURE:      get_cis_hia_angles, ntheta, nphi, theta, phi, dtheta, dphi
;INPUT:
;       ntheta: Number of theta bins
;	nphi: Number of phi bins
;	theta: Variable to return theta values
;	phi: Variable to return phi values
;	dtheta: Variable to return dtheta values
;	dphi: Variable to return dphi values
;
;PURPOSE:   Calculate CIS/HIA angle bins.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
pro get_cis_hia_angles, ntheta, nphi, theta, phi, dtheta, dphi

if ntheta ne 0 then begin
	dtheta = 180./ntheta
	theta = (findgen(ntheta)+0.5)*dtheta - 90.
endif

if nphi ne 0 then begin
	dphi = 360./nphi
	phi = (findgen(nphi)+0.5)*dphi
endif

return
end

