;+
;PROCEDURE:     get_cis_hia_energies, dtime, sat, nenergy, tel_mode, hvtbl, $
;	energy, denergy
;INPUT:
;       dtime: Time of interest in time_double format.
;       sat: Satellite number (1-4)
;       nenergy: Number of energy bins
;       tel_mode: Telemetry mode (0-15)
;       hvtbl: High voltage lookup table
;       energy: Variable to return energy values
;       denergy: Variable to return denergy values
;
;PURPOSE:   Calculate CIS/CODIF energy bins.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
pro get_cis_hia_prom_energies, dtime, sat, nenergy, energy, denergy
cal_struct = get_cis_cal(dtime, sat, 'CIS2')

e_table = cal_struct.energy_sweep_table_prom

n = fix(e_table[0])

energy_upper = fltarr(n)

n = total_all_energies
emax = float(e_table[1])
emin = float(e_table[2])
l1orl2 = e_table[3]
if (l1orl2 eq 'L1') then $
	k = exp( alog( emin/emax ) / (float(n) - 1.) ) $
else $
	k = exp( alog( emin/emax ) / float(n) )
for i = 0,n-1 do $
	energy_upper[i+ibase] = emax * k^i

energy_lower = [energy_upper[1:*],0]

energy = fltarr(nenergy)
denergy = energy
comp_factor = total_all_energies/nenergy

for i = 0,nenergy-1 do begin
	energy[i] = (energy_upper[i*comp_factor] + $
		energy_lower[(i+1)*comp_factor-1])/2.
	denergy[i] = energy_upper[i*comp_factor] - $
		energy_lower[(i+1)*comp_factor-1]
endfor

return
end

pro get_cis_hia_energies, dtime, sat, nenergy, tel_mode, hvtbl, energy, denergy

if tel_mode eq 7 then begin
	get_cis_hia_prom_energies, dtime, sat, nenergy, energy, denergy
	return
endif

if hvtbl eq 10 then etbl = 0 else etbl = hvtbl

cal_struct = get_cis_cal(dtime, sat, 'CIS2')

e_tables = cal_struct.energy_sweep_table

e_indx = where(fix(e_tables[0,*]) eq etbl, e_cnt)

total_all_energies = total(fix(e_tables[1,e_indx]))

energy_upper = fltarr(total_all_energies)

ibase = 0
for j = 0, e_cnt-1 do begin
	this_indx = e_indx[j]
	n = fix(e_tables[1, this_indx])
	emax = float(e_tables[2, this_indx])
	emin = float(e_tables[3, this_indx])
	l1orl2 = e_tables[4, this_indx]
	if (l1orl2 eq 'L1') then $
		k = exp( alog( emin/emax ) / (float(n) - 1.) ) $
	else $
		k = exp( alog( emin/emax ) / float(n) )
	for i = 0,n-1 do $
		energy_upper[i+ibase] = emax * k^i
	ibase = ibase + n
endfor


energy_lower = [energy_upper[1:*],0]

if hvtbl eq 10 then begin
	sw_stop = fix(cal_struct.sw_energy_sweep_stop)
	energy_upper = energy_upper[0:sw_stop]
	energy_lower = energy_lower[0:sw_stop]
	total_all_energies = sw_stop + 1
endif

energy = fltarr(nenergy)
denergy = energy
comp_factor = total_all_energies/nenergy

for i = 0,nenergy-1 do begin
	energy[i] = (energy_upper[i*comp_factor] + $
		energy_lower[(i+1)*comp_factor-1])/2.
	denergy[i] = energy_upper[i*comp_factor] - $
		energy_lower[(i+1)*comp_factor-1]
endfor

return
end
