;+
;FUNCTION:      get_cis_hia_p6, sat, t, index=index, time=time
;INPUT:
;	t: Time of interest
;	index: Data index (alternative to using t)
;	sat: Satellite number (1-4)
;	time: If set, return time array of data values
;
;PURPOSE:   Retrieve HIA/CODIF P6 data.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_hia_p6, sat, t, index=index, time=time

prod_num = 6
nenergy = 31
nangles = 88

options = [long(sat),1l,long(prod_num),0l]
if keyword_set(time) then return,get_cis_data_times(options)

if arg_present(index) then $
	basic_data = get_cis_data(options,index) $
else basic_data = get_cis_data_by_time(options,time_double(t),index)

if not keyword_set(basic_data) then return, 0

dtime = cis_tplot_time(basic_data.header.time_in_ms)
sensitivity = basic_data.header.sensitivity
delta_t = basic_data.header.pspin/1d3

hvtbl = basic_data.data.hvtbl
tel_mode = basic_data.header.op_mode
stop
get_cis_hia_energies,dtime,sat,nenergy,tel_mode,hvtbl,energy,denergy
energy_arr = fltarr(nenergy,nangles)
denergy_arr = energy_arr
for i = 0,nangles-1 do begin
        energy_arr[*,i] = energy
        denergy_arr[*,i] = denergy
endfor

theta_arr = fltarr(nangles)
phi_arr = fltarr(nangles)
ntheta = 8
nphi = 4
get_cis_hia_angles,ntheta,nphi,theta,phi,dtheta,dphi
for i = 0,nphi-1 do begin
	theta_arr[i] = theta[0]
	phi_arr[i] = phi[i]
endfor
ntheta = 8
nphi = 8
get_cis_hia_angles,ntheta,nphi,theta,phi,dtheta,dphi
for i = 0,nphi-1 do begin
	theta_arr[4+i] = theta[1]
	phi_arr[4+i] = phi[i]
endfor
ntheta = 8
nphi = 16
get_cis_hia_angles,ntheta,nphi,theta,phi,dtheta,dphi
for j = 0,3 do begin
	for i = 0,nphi-1 do begin
		theta_arr[12 + i + j*ntheta] = theta[j+2]
		phi_arr[12 + i + j*ntheta] = phi[i]
	endfor
endfor
ntheta = 8
nphi = 8
get_cis_hia_angles,ntheta,nphi,theta,phi,dtheta,dphi
for i = 0,nphi-1 do begin
	theta_arr[76+i] = theta[6]
	phi_arr[76+i] = phi[i]
endfor
ntheta = 8
nphi = 4
get_cis_hia_angles,ntheta,nphi,theta,phi,dtheta,dphi
for i = 0,nphi-1 do begin
	theta_arr[84+i] = theta[6]
	phi_arr[84+i] = phi[i]
endfor

retdata = { $
	project_name: 'CLUSTER HIA', $
	data_name: 'Product '+strcompress(prod_num,/rem), $
	data_product: prod_num, $
	units_name: 'Counts', $
	units_procedure: 'convert_hia_units', $
	valid: 1, $
	time: dtime, $
	end_time: dtime+delta_t, $
	delta_t: delta_t, $
	integ_t: delta_t, $
	geom_factor: get_cis_hia_geom_factor(dtime, sat, sensitivity), $
	index: long(index), $
	nenergy: nenergy, $
	nbins: replicate(1b, nenergy, nphi*ntheta), $
	energy: energy_arr, $
	denergy: denergy_arr, $
	theta: theta_arr, $
	phi: phi_arr, $
	dtheta: dtheta, $
	dphi: dphi, $
	eff: 1., $
	hvtbl: basic_data.data.hvtbl, $
	eband: basic_data.data.eband, $
	fore_acc_spins: basic_data.data.fore_acc_spins, $
	real_acc_spins: basic_data.data.real_acc_spins, $
	data: basic_data.data.data }
	
return, retdata
end
