;+
;FUNCTION:      get_cis_hia_p5, sat, t, index=index, time=time
;INPUT:
;	t: Time of interest
;	index: Data index (alternative to using t)
;	sat: Satellite number (1-4)
;	time: If set, return time array of data values
;
;PURPOSE:   Retrieve HIA/CODIF P5 data.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
function get_cis_hia_p7, sat, t, index=index, time=time

prod_num = 7
nenergy = 31
nangles = 42
hvtbl = 0

options = [long(sat),1l,long(prod_num),0l]
if keyword_set(time) then return,get_cis_data_times(options)

if arg_present(index) then $
	basic_data = get_cis_data(options,index) $
else basic_data = get_cis_data_by_time(options,time_double(t),index)

if not keyword_set(basic_data) then return, 0

dtime = cis_tplot_time(basic_data.header.time_in_ms)
sensitivity = basic_data.header.sensitivity
delta_t = basic_data.header.pspin/1d3

tel_mode = basic_data.header.op_mode
get_cis_hia_energies,dtime,sat,nenergy,tel_mode,hvtbl,energy,denergy
energy_arr = fltarr(nenergy,nangles)
denergy_arr = energy_arr
for i = 0,nangles-1 do begin
        energy_arr[*,i] = energy
        denergy_arr[*,i] = denergy
endfor

retdata = { $
	project_name: 'CLUSTER HIA', $
	data_product: prod_num, $
	units_name: 'Counts', $
	time: dtime, $
	delta_t: delta_t, $
	integ_t: delta_t, $
	geom_factor: get_cis_hia_geom_factor(dtime, sat, sensitivity), $
	index: long(index), $
	eff: 1., $
	fore_acc_spins: basic_data.data.fore_acc_spins, $
	real_acc_spins: basic_data.data.real_acc_spins, $
	data: basic_data.data.data }
	
return, retdata
end
