;+
;PROCEDURE:      load_cis_cal_file, filename, calstruct
;INPUT:
;	filename: Name of calibration file to load
;	calstruct: Variable to return calibration structure
;
;PURPOSE:   Load CIS calibration data.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  August 2000
;
;-
pro load_cis_cal_file, filename, calstruct

cal_dir = getenv('CLUSCAL')

cal_file = cal_dir+'/'+filename

thiscalstruct = 0

namepos = rstrpos(cal_file,'_L1_')-2
instrstr = strmid(cal_file,namepos+9,3)
typestr = strmid(cal_file,namepos+26,10)
instrtypestr = instrstr+typestr
xpos = strpos(instrtypestr, 'x')
fieldname = strmid(instrtypestr,0,xpos)
print,fieldname

openr,filelun,cal_file,/get_lun
	
aline = ''
repeat readf,filelun,aline until strmid(aline,0,1) ne '#'
j = 0
	
repeat begin
	if strmid(aline,0,5) eq 'BEGIN' then begin
		subfieldname = strcompress(strmid(aline,5,strlen(aline)-5),$
			/remove_all)
		repeat readf,filelun,aline until aline ne ''
		if strmid(aline,0,3) ne 'END' then begin
			aline_sepd = str_sep(strcompress(aline),' ')
			aline_sepd = aline_sepd[1:*]
	
			subfielddata = strarr(n_elements(aline_sepd),300)
			subfielddata[*,0] = aline_sepd
	
			j = 1
			repeat readf,filelun,aline until aline ne ''
			while strmid(aline,0,3) ne 'END' do begin
				aline_sepd = str_sep(strcompress(aline),' ')
				aline_sepd = aline_sepd[1:*]
				subfielddata[*,j] = aline_sepd
				j = j+1
				repeat readf,filelun,aline until aline ne ''
			endwhile
			subfielddata = reform(subfielddata[*,0:j-1])
			str_element,thiscalstruct,subfieldname,subfielddata,/add
		endif
	endif else begin
		aline_sepd = str_sep(strcompress(aline),' ')
		if aline_sepd[0] eq ' ' then $
			aline_sepd = aline_sepd[1:*]
		if not keyword_set(thiscalstruct) then $
			thiscalstruct = strarr(n_elements(aline_sepd),300)
		thiscalstruct[*,j] = aline_sepd
		j = j+1
	endelse
	repeat readf,filelun,aline until strmid(aline,0,1) ne '#'
endrep until eof(filelun)
	
if data_type(thiscalstruct) ne 8 then $
	calstruct = reform(thiscalstruct[*,0:j-1]) $
else calstruct = thiscalstruct

close,filelun
free_lun,filelun

return
end

	