;+
;PROCEDURE:	load_cis_data, sat, inst, prod, date, bm3=bm3
;INPUT:
;    sat: Satellite number (1-4)
;    inst: Instrument (0: CODIF, 1: HIA)
;    prod: Product number
;    bm3: if set, load bm3 data
;    date: date of file to load in form recognizable by time_double.
;
;PURPOSE:   Load Cluster/CIS data into memory.
;
;CREATED BY:    Peter Schroeder
;LAST MODIFICATION:  June 2000
;
;-
pro load_cis_data, sat, inst, prod, dtime, bm3=bm3

options = [long(sat), long(inst), long(prod), long(keyword_set(bm3))]

l1toidl_lib = getenv('L1TOIDL_LIB')
l1datadir = getenv('L1DATA')

if keyword_set(dtime) then begin
	err=call_external(l1toidl_lib,'reset_buffers')
	filetime = time_double(dtime)
	if n_elements(filetime) eq 1 then $
		filetime = filetime + [0d, 60d*60d*24d]
	timespan,filetime
endif else get_timespan,filetime

date_str_arr = [time_string(filetime[0],format=2,prec=-3),$
		time_string(filetime[1]-1d,format=2,prec=-3)]

if date_str_arr[0] eq date_str_arr[1] then $
	date_str_arr = date_str_arr[0] $
else begin
	done = 0
	last_date_str = date_str_arr[1]
	date_str_arr = date_str_arr[0]
	date_dummy = filetime[0]
	while done eq 0 do begin
		date_dummy = date_dummy + 60d*60d*24d
		next_date_str = time_string(date_dummy,format=2,prec=-3)
		date_str_arr = [date_str_arr,next_date_str]
		if next_date_str eq last_date_str then done = 1
	endwhile
endelse

for i = 0,n_elements(date_str_arr)-1 do begin

	date_str = date_str_arr[i]

	sat_num = options[0]
	sat_num = strcompress(string(sat_num),/rem)

	data_dir = l1datadir+'/'+date_str+'/CLUSTER'+sat_num+'/'

	options = long(options)

	file_str = get_cis_filename(options,date_str)

	filename = findfile(data_dir+file_str,count=file_cnt)

	if file_cnt gt 0 then $
		err = call_external(l1toidl_lib,'load_cis_idl',options,$
			filename[0])
endfor

return
end

